/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jodatime;

import java.lang.reflect.Method;
import java.util.Properties;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.jodatime.annotation.FixedDateTime;
import org.unitils.jodatime.annotation.OffsetDateTime;

public class JodaTimeModule
implements Module {
    public void init(Properties configuration) {
    }

    public void afterInit() {
    }

    protected void changeDate(FixedDateTime dateTime) {
        DateTimeUtils.setCurrentMillisFixed((long)this.calculateFixedMillis(dateTime));
    }

    protected void changeDate(OffsetDateTime dateTime) {
        DateTimeUtils.setCurrentMillisOffset((long)this.calculateOffsetMillis(dateTime));
    }

    protected long calculateFixedMillis(FixedDateTime fixedDateTime) {
        if (fixedDateTime.datetime() == null || fixedDateTime.datetime().length() == 0) {
            return new DateTime().getMillis();
        }
        DateTime dateTime = DateTimeFormat.forPattern((String)fixedDateTime.pattern()).parseDateTime(fixedDateTime.datetime());
        return dateTime.getMillis();
    }

    protected long calculateOffsetMillis(OffsetDateTime offsetDateTime) {
        Period period = new Period(offsetDateTime.years(), offsetDateTime.months(), offsetDateTime.weeks(), offsetDateTime.days(), offsetDateTime.hours(), offsetDateTime.minutes(), offsetDateTime.seconds(), offsetDateTime.millis());
        DateTime currentDate = new DateTime();
        DateTime offisetDate = currentDate.plus((ReadablePeriod)period);
        Duration duration = new Duration((ReadableInstant)currentDate, (ReadableInstant)offisetDate);
        return duration.getMillis();
    }

    public TestListener getTestListener() {
        return new DateTimeModuleListener();
    }

    protected class DateTimeModuleListener
    extends TestListener {
        protected DateTimeModuleListener() {
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            DateTimeUtils.setCurrentMillisSystem();
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            if (testMethod.isAnnotationPresent(FixedDateTime.class)) {
                JodaTimeModule.this.changeDate(testMethod.getAnnotation(FixedDateTime.class));
            } else if (testMethod.isAnnotationPresent(OffsetDateTime.class)) {
                JodaTimeModule.this.changeDate(testMethod.getAnnotation(OffsetDateTime.class));
            } else if (testObject.getClass().isAnnotationPresent(FixedDateTime.class)) {
                JodaTimeModule.this.changeDate(testObject.getClass().getAnnotation(FixedDateTime.class));
            } else if (testObject.getClass().isAnnotationPresent(OffsetDateTime.class)) {
                JodaTimeModule.this.changeDate(testObject.getClass().getAnnotation(OffsetDateTime.class));
            } else {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }
    }
}

