/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mail.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.subethamail.wiser.WiserMessage;
import org.unitils.mail.SmtpMessage;

public class SmtpMessageImpl
implements SmtpMessage {
    private String from;
    private String subject;
    private String body;
    private List<String> to;
    private List<String> cc;
    private List<String> bcc;
    private List<byte[]> attachments;

    public SmtpMessageImpl(String from, String subject, String body, String to) throws IOException {
        this(from, subject, body, to, new File[0]);
    }

    public SmtpMessageImpl(String from, String subject, String body, String to, File ... attachments) throws IOException {
        this(from, subject, body, Arrays.asList(to), new ArrayList<String>(), attachments);
    }

    public SmtpMessageImpl(String from, String subject, String body, List<String> to, List<String> cc, File ... attachments) throws IOException {
        this(from, subject, body, to, cc, new ArrayList<String>(), attachments);
    }

    public SmtpMessageImpl(String from, String subject, String body, List<String> to, List<String> cc, List<String> bcc, File ... attachments) throws IOException {
        this.from = from;
        this.subject = subject;
        this.body = body;
        this.to = to != null ? to : new ArrayList<String>();
        this.cc = cc != null ? cc : new ArrayList<String>();
        this.bcc = bcc != null ? bcc : new ArrayList<String>();
        if (attachments == null) {
            this.attachments = new ArrayList<byte[]>();
        } else {
            this.attachments = new ArrayList<byte[]>();
            for (File file : attachments) {
                byte[] readFileToByteArray = FileUtils.readFileToByteArray((File)file);
                this.attachments.add(readFileToByteArray);
            }
        }
    }

    public SmtpMessageImpl(WiserMessage message) throws IOException, MessagingException {
        MimeMessage mimeMessage = message.getMimeMessage();
        this.from = message.getEnvelopeSender();
        this.subject = mimeMessage.getSubject();
        this.body = mimeMessage.getDescription();
        this.to = new ArrayList<String>();
        if (mimeMessage.getRecipients(Message.RecipientType.TO) != null) {
            for (Address address : mimeMessage.getRecipients(Message.RecipientType.TO)) {
                this.to.add(address.toString());
            }
        }
        this.cc = new ArrayList<String>();
        if (mimeMessage.getRecipients(Message.RecipientType.CC) != null) {
            for (Address address : mimeMessage.getRecipients(Message.RecipientType.CC)) {
                this.cc.add(address.toString());
            }
        }
        this.bcc = new ArrayList<String>();
        if (mimeMessage.getRecipients(Message.RecipientType.BCC) != null) {
            for (Address address : mimeMessage.getRecipients(Message.RecipientType.BCC)) {
                this.bcc.add(address.toString());
            }
        }
        this.attachments = new ArrayList<byte[]>();
        this.attachments = this.getAttachmentsOutOfMimeMesage(mimeMessage);
    }

    private List<byte[]> getAttachmentsOutOfMimeMesage(MimeMessage message) throws IOException, MessagingException {
        MimeMessage tempMessage = message;
        ArrayList<byte[]> tempListAttachments = new ArrayList<byte[]>();
        if (tempMessage.getContent() instanceof Multipart) {
            this.getPartsMultipart((Multipart)tempMessage.getContent(), tempListAttachments);
        } else if (tempMessage.getContent() instanceof String) {
            this.body = ((String)tempMessage.getContent()).trim();
        }
        return tempListAttachments;
    }

    private void getPartsMultipart(Multipart multipart, List<byte[]> lstAttachments) throws MessagingException, IOException {
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (bodyPart.getContent() instanceof Multipart) {
                this.getPartsMultipart((Multipart)bodyPart.getContent(), lstAttachments);
            }
            if (bodyPart.getContent() instanceof String) {
                this.body = (String)bodyPart.getContent();
                continue;
            }
            if (!(bodyPart.getContent() instanceof InputStream)) continue;
            lstAttachments.add(IOUtils.toByteArray((InputStream)((InputStream)bodyPart.getContent())));
        }
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public List<String> getTo() {
        return Collections.unmodifiableList(this.to);
    }

    @Override
    public List<byte[]> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    @Override
    public List<String> getBcc() {
        return Collections.unmodifiableList(this.bcc);
    }

    @Override
    public List<String> getCc() {
        return Collections.unmodifiableList(this.cc);
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SmtpMessageImpl [from=" + this.from + ", subject=" + this.subject + ", body=" + this.body + ", ");
        if (this.to.size() > 0) {
            buffer.append("to=[");
            for (i = 0; i < this.to.size() - 1; ++i) {
                buffer.append(" " + this.to.get(i) + ", ");
            }
            buffer.append(this.to.get(this.to.size() - 1));
            buffer.append("],");
        }
        if (this.cc.size() > 0) {
            buffer.append("cc=[");
            for (i = 0; i < this.cc.size() - 1; ++i) {
                buffer.append(" " + this.cc.get(i) + ", ");
            }
            buffer.append(this.cc.get(this.cc.size() - 1));
            buffer.append("], ");
        }
        if (this.bcc.size() > 0) {
            buffer.append("bcc=[");
            for (i = 0; i < this.bcc.size() - 1; ++i) {
                buffer.append(" " + this.bcc.get(i) + ", ");
            }
            buffer.append(this.bcc.get(this.bcc.size() - 1));
            buffer.append("],");
        }
        buffer.append(" attachement size : " + this.attachments.size() + " ]");
        return buffer.toString();
    }
}

