/*
 * Copyright 2012,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.mail;

import java.util.List;


/**
 * This is the SMTP message .
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 */

public interface SmtpMessage {

    /**
     * This method gives you the from header of the email.
     * @return {@link String}
     */
    String getFrom();

    /**
     * This method gives you the subject of the email .
     * @return {@link String}
     */
    String getSubject();

    /**
     * This method gives you the receiver of the email.
     * @return {@link String}
     */
    List<String> getTo();
    /**
     * This method gives you the text body of the email.
     * @return {@link String}
     */
    String getBody();

    /**
     * This method give you the attachments of the email.
     * 
     * @return {@link List}
     */
    List<byte[]> getAttachments();

    /**
     * This will return the BCC addresses of the email.
     * @return {@link List}
     */
    List<String> getBcc();
    
    /**
     * This will return the CC addresses of the email.
     * @return {@link List}
     */
    List<String> getCc();
}
