/*
 * Copyright 2012,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.mail;

import java.io.IOException;
import java.util.List;

import javax.mail.MessagingException;


/**
 * Interface for the wrapper of the SimpleSmtpServer of Wiser.
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 */
public interface SmtpServer {

    /**
     * This method give you the amount of mails that you've sent to the SMTP server.
     * 
     * @return int
     */
    int getReceivedEmailSize();

    /**
     * This email sends you a list of all the mails you've sent to the fake SMTP server.
     * 
     * @return List<SmtpMessage>
     * @throws MessagingException
     * @throws IOException
     */
    List<SmtpMessage> getReceivedEmail() throws IOException, MessagingException;

    /**
     * This method will stop the SMTP server.
     */
    void stop();

    /**
     * Returns if the server is running or not.
     * @return {@link Boolean}
     */
    Boolean isRunning();


}
