/*
 * Copyright 2012,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.mail.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.mail.MessagingException;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;
import org.unitils.mail.SmtpMessage;
import org.unitils.mail.SmtpServer;



/**
 * Wrapper class for the SimpleSmtpServer of Wiser.
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 */
public class SmtpServerImpl implements SmtpServer {

    private Wiser wiser;


    /**
     * @param port
     */
    public SmtpServerImpl(int port) {
        wiser = new Wiser();
        wiser.setPort(port);
        wiser.start();
    }

    /**
     * It returns all the mails that were received on the fake SMTP server.
     * @return List<SmtpMessage>
     * @throws MessagingException
     * @throws IOException
     */
    @Override
    public List<SmtpMessage> getReceivedEmail() throws IOException, MessagingException {

        List<SmtpMessage> messages = new ArrayList<SmtpMessage>();
        for (WiserMessage wiserMessage : wiser.getMessages()) {
            SmtpMessage smtpmessage = new SmtpMessageImpl(wiserMessage);
            messages.add(smtpmessage);
        }
        return messages;
    }

    @Override
    public int getReceivedEmailSize() {
        return wiser.getMessages().size();

    }

    /**
     * 
     */
    @Override
    public void stop() {
        wiser.stop();
    }

    @Override
    public Boolean isRunning() {
        return wiser.getServer().isRunning();

    }

}
