/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mail;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.mail.SmtpServer;
import org.unitils.mail.annotation.TestSmtpServer;
import org.unitils.mail.impl.SmtpServerImpl;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class MailModule
implements Module {
    private static Log LOGGER = LogFactory.getLog(MailModule.class);
    public static final String SMTP_DEFAULT_PORT = "org.unitils.mail.port";
    private int port;

    public void init(Properties configuration) {
        this.port = PropertyUtils.getInt((String)SMTP_DEFAULT_PORT, (int)25, (Properties)configuration);
    }

    public void afterInit() {
    }

    public void initSmtpServer(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestSmtpServer.class);
        if (fields.size() > 1) {
            throw new UnitilsException("Multiple SmtpServer declarations found. Module support only one. ");
        }
        if (fields.size() == 1) {
            Field field = (Field)fields.iterator().next();
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)new SmtpServerImpl(this.port));
        }
    }

    public void stopSmtpServer(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestSmtpServer.class);
        for (Field field : fields) {
            SmtpServer server = (SmtpServer)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            server.stop();
            if (!server.isRunning().booleanValue()) continue;
            LOGGER.warn((Object)("smtp server was not shut down correctly, port " + this.port + " could still be open. "));
        }
    }

    public TestListener getTestListener() {
        return new MailListener();
    }

    private class MailListener
    extends TestListener {
        private MailListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            MailModule.this.initSmtpServer(testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            MailModule.this.stopSmtpServer(testObject);
        }
    }
}

