package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * This generator will take care of interfaces and the classes that have no custom generator.
 * 
 * "Cut this object into pieces this is your last resort! "
 * 
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class CollectionGenerator implements Generator {


    @Override
    @SuppressWarnings("rawtypes")
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception {

        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(Map.class)) {
                return new HashMap();
            }
            if (clazz.isAssignableFrom(List.class)) {
                return new ArrayList();
            }
            if (clazz.isAssignableFrom(Set.class)) {
                return new HashSet();
            }
        }

        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }

        return null;
    }


}
