package org.unitils.objectvalidation.objectcreator.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


/**
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class CompositeGenerator implements Generator {

    private List<Generator> generators;

    public CompositeGenerator(List<Generator> generators) {
        this.generators = generators;
    }

    public CompositeGenerator() {
        this(new ArrayList<Generator>());
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception {

        for (Generator generator : generators) {
            Object result = generator.generateObject(clazz, input, inputClasses);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public void addGenerators(Generator... generator) {
        generators.addAll(Arrays.asList(generator));
    }

}
