package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.util.List;

import org.unitils.util.ReflectionUtils;


/**
 * This generator will take care of interfaces and the classes that have no custom generator.
 * "Cut this object into pieces this is your last resort! "
 * 
 * @author Jeroen Horemans
 * @since 1.1.6
 */
public class LastResortGenerator implements Generator {


    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception {

        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }

        if (!input.isEmpty() && !inputClasses.isEmpty()) {
            Class<?>[] inputTypes = inputClasses.toArray(new Class<?>[inputClasses.size()]);
            return ReflectionUtils.createInstanceOfType(clazz, true, inputTypes, input.toArray());
        }
        return clazz.newInstance();
    }

}
