package org.unitils.objectvalidation.rules;

import static java.lang.reflect.Modifier.isFinal;
import static org.junit.Assert.assertTrue;

import org.unitils.objectvalidation.Rule;


/**
 * Rule to check that the class is final.
 * 
 * @author Matthieu Mestrez
 * @since Oct 24, 2013
 */
public class ClassIsFinalRule implements Rule {

    @Override
    public void validate(Class<?> classToValidate) {
        assertTrue("The class " + classToValidate.getName() + " was expected to be final.",isFinal(classToValidate.getModifiers()));
    }

}
