package org.unitils.objectvalidation.rules;

import static java.lang.reflect.Modifier.isFinal;
import static java.lang.reflect.Modifier.isPrivate;
import static java.lang.reflect.Modifier.isStatic;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.Serializable;
import java.lang.reflect.Field;

import org.unitils.objectvalidation.Rule;
import org.unitils.util.ReflectionUtils;


/**
 * Rule to check that the class passed in parameter must implement {@link java.io.Serializable}.
 * 
 * @author Matthieu Mestrez
 * @since Oct 23, 2013
 */
public class ClassMustBeSerializableRule implements Rule {
    
    @Override
    public void validate(Class<?> classToValidate) {
        assertTrue("Class " + classToValidate.getName() + " is not Serializable.", classToValidate instanceof Serializable);
        assertSerialsVersionUIDExists(classToValidate);
    }

    private void assertSerialsVersionUIDExists(Class<?> classToValidate) {
        Field field = ReflectionUtils.getFieldWithName(classToValidate, "serialVersionUID", true);
        assertNotNull("Class " + classToValidate.getName() + " does not contains serialVersionUID field.", field);
        assertTrue(isFinal(field.getModifiers()));
        assertTrue(isPrivate(field.getModifiers()));
        assertTrue(isStatic(field.getModifiers()));
    }
}
