package org.unitils.objectvalidation.rules;

import static junit.framework.Assert.assertTrue;

import org.unitils.objectvalidation.Rule;


/**
 * Rule to check that no public constructors are available on the tested class.
 * 
 * @author Matthieu Mestrez
 * @since Oct 23, 2013
 */
public class PrivateConstructorRule implements Rule {

    @Override
    public void validate(Class<?> classToValidate) {
        assertTrue(classToValidate.getConstructors().length == 0);
    }
    
}
