package org.unitils.objectvalidation.rules;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.lang.reflect.Constructor;

import org.unitils.objectvalidation.Rule;


/**
 * Rules to verify that the provided class has a default empty constructor.
 * 
 * @author Matthieu Mestrez
 * @since Oct 22, 2013
 */
public class PublicEmptyConstructorRule implements Rule {

    @Override
    public void validate(Class<?> classToValidate) {
        try {
            Constructor<?> constructor = classToValidate.getConstructor();
            assertNotNull(constructor);
        } catch (NoSuchMethodException e) {
            fail("There is no public empty constructor for the class " + classToValidate.getName() + " therefore it is not a proper bean.");
        } catch (SecurityException e) {
            fail("The security is enabled, impossible to check if there is a public empty constructor for the type " + classToValidate.getName());
        }
    }

}
