/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation;

import java.util.List;
import org.unitils.objectvalidation.EqualsHashCodeValidator;
import org.unitils.objectvalidation.Rule;
import org.unitils.objectvalidation.utils.Utils;

public class ObjectValidator {
    private List<Rule> rulesToValidate;
    private List<EqualsHashCodeValidator> equalsHashCodeValidator;

    public ObjectValidator(List<Rule> rulesToValidate, List<EqualsHashCodeValidator> equalsHashCodeValidator) {
        Utils.checkNotNull(rulesToValidate, "The list of rules cannot be null");
        Utils.checkNotNull(equalsHashCodeValidator, "The equals and hashCode validator cannot be null");
        this.rulesToValidate = rulesToValidate;
        this.equalsHashCodeValidator = equalsHashCodeValidator;
    }

    public void validate(Class<?> classToValidate) {
        for (Rule rule : this.rulesToValidate) {
            rule.validate(classToValidate);
        }
    }

    public void validate(List<Class<?>> classesToValidate) {
        for (Class<?> classToValidate : classesToValidate) {
            this.validate(classToValidate);
        }
    }

    public void validate(Class<?> ... classesToValidate) {
        for (Class<?> classToValidate : classesToValidate) {
            this.validate(classToValidate);
        }
    }

    public void validateEqualsAndHashCodeIgnoring(Class<?> classToValidate, String ... fieldsToIgnore) {
        for (EqualsHashCodeValidator validator : this.equalsHashCodeValidator) {
            validator.validateIgnoring(classToValidate, fieldsToIgnore);
        }
    }

    public void validateEqualsAndHashCodeIgnoring(Class<?> classToValidate, List<String> fieldsToIgnore) {
        for (EqualsHashCodeValidator validator : this.equalsHashCodeValidator) {
            validator.validateIgnoring(classToValidate, fieldsToIgnore);
        }
    }

    public void validateEqualsAndHashCodeForFields(Class<?> classToValidate, List<String> onlyFields) {
        for (EqualsHashCodeValidator validator : this.equalsHashCodeValidator) {
            validator.validateOnly(classToValidate, onlyFields);
        }
    }

    public void validateEqualsAndHashCodeForFields(Class<?> classToValidate, String ... onlyFields) {
        for (EqualsHashCodeValidator validator : this.equalsHashCodeValidator) {
            validator.validateOnly(classToValidate, onlyFields);
        }
    }
}

