/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.util.ReflectionUtils;

public class BuilderGenerator
implements Generator {
    private static final List<String> FIELD_NAMES_TO_BE_IGNORED = Arrays.asList("serialVersionUID", "$jacocoData");

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception {
        try {
            clazz.getMethod("build", new Class[0]);
            return this.fillInFields(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object fillInFields(Class<?> clazz) {
        Set fields = ReflectionUtils.getAllFields(clazz);
        ObjectCreator objectCreator = ObjectCreatorFactory.createDefaultObjectCreator();
        try {
            Object builder = clazz.newInstance();
            for (Field field : fields) {
                if (FIELD_NAMES_TO_BE_IGNORED.contains(field.getName())) continue;
                Object fieldValue = objectCreator.createRandomObject(field.getType());
                ReflectionUtils.setFieldValue(builder, (Field)field, (Object)fieldValue);
            }
            return builder;
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("Builder for " + clazz.getName() + " could not be instantiated", exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Builder for " + clazz.getName() + " could not be instantiated", exception);
        }
    }
}

