/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.unitils.objectvalidation.objectcreator.generator.Generator;

public class PrimitiveGenerator
implements Generator {
    private Random random = new Random(new Date().getTime());
    private static final char[] CHARACTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception {
        return this.generateJavaDefaultClass(clazz);
    }

    protected Object generateJavaDefaultClass(Class<?> type) {
        Object temp = this.testIfClassIsNumber(type);
        if (temp != null) {
            return temp;
        }
        temp = this.testIfClassContainsText(type);
        if (temp != null) {
            return temp;
        }
        temp = this.testIfClassIsDate(type);
        if (temp != null) {
            return temp;
        }
        return null;
    }

    private Object testIfClassIsNumber(Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this.random.nextBoolean();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.random.nextInt();
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf(this.random.nextLong());
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(this.random.nextFloat());
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.random.nextDouble();
        }
        if (type == BigDecimal.class) {
            return BigDecimal.valueOf(this.random.nextDouble());
        }
        if (type == Long.TYPE || type == Long.class) {
            return this.random.nextLong();
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)(this.random.nextInt(32768) * (this.random.nextBoolean() ? 1 : -1));
        }
        if (type == Byte.TYPE || type == Byte.class) {
            byte[] randombyte = new byte[1];
            this.random.nextBytes(randombyte);
            return randombyte[0];
        }
        return null;
    }

    private Object testIfClassContainsText(Class<?> type) {
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(CHARACTERS[this.random.nextInt(CHARACTERS.length)]);
        }
        if (type == String.class) {
            StringBuffer randomString = new StringBuffer(5);
            for (int count = 0; count < this.random.nextInt(7) + 1; ++count) {
                randomString.append(this.generateJavaDefaultClass(Character.class));
            }
            return randomString.toString();
        }
        return null;
    }

    private Object testIfClassIsDate(Class<?> type) {
        if (type == Date.class) {
            return new Date((Long)this.generateJavaDefaultClass(Long.class));
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date((Long)this.generateJavaDefaultClass(Long.class));
        }
        if (type == Timestamp.class) {
            return new Timestamp((Long)this.generateJavaDefaultClass(Long.class));
        }
        if (type == Calendar.class) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((Long)this.generateJavaDefaultClass(Long.class));
            return calendar;
        }
        return null;
    }
}

