/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.Rule;

public class ToStringMustContainsEveryFieldRule
implements Rule {
    private static final List<String> FIELDS_NAME_TO_IGNORE = Arrays.asList("serialVersionUID", "$jacocoData");
    private ObjectCreator objectCreator;

    public ToStringMustContainsEveryFieldRule(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    @Override
    public void validate(Class<?> classToValidate) {
        Field[] fields = classToValidate.getDeclaredFields();
        Object objectToTest = this.objectCreator.createRandomObject(classToValidate);
        for (Field field : fields) {
            if (FIELDS_NAME_TO_IGNORE.contains(field.getName())) continue;
            Assert.assertTrue((String)("The field " + classToValidate.getName() + "." + field.getName() + " is not in the toString :\n" + objectToTest.toString()), (boolean)objectToTest.toString().contains(field.getName()));
        }
    }
}

