/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.utils;

import java.util.LinkedList;
import java.util.List;

public class TreeNode {
    private static final String IDENTATION = "   ";
    private Class<?> value;
    private TreeNode parent;
    private List<TreeNode> childs;

    public TreeNode(Class<?> value) {
        this.value = value;
        this.childs = new LinkedList<TreeNode>();
    }

    public void addChild(TreeNode child) {
        child.setParent(this);
        this.childs.add(child);
    }

    public TreeNode addChild(Class<?> child) {
        TreeNode node = new TreeNode(child);
        this.addChild(node);
        return node;
    }

    public Class<?> getValue() {
        return this.value;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChilds() {
        return this.childs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("\n");
        return this.toString(this, builder, "").toString();
    }

    public StringBuilder toString(TreeNode node, StringBuilder builder, String idents) {
        builder.append(idents).append("->").append(node.getValue().getName()).append("\n");
        for (TreeNode child : node.getChilds()) {
            this.toString(child, builder, idents + IDENTATION);
        }
        return builder;
    }
}

