/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.unitils.objectvalidation.EqualsHashCodeValidator;
import org.unitils.objectvalidation.ObjectValidationRulesCollection;
import org.unitils.util.AnnotationUtils;

public final class Utils {
    private Utils() {
    }

    public static <T> List<Field> findOneAndOnlyFieldForAnnotation(Class<? extends Object> classContainingField, Class<? extends Annotation> annotation, Class<T> fieldType) {
        Set objectValidatorFields = AnnotationUtils.getFieldsAnnotatedWith(classContainingField, annotation);
        ArrayList<Field> foundFields = new ArrayList<Field>();
        for (Field field : objectValidatorFields) {
            if (!Utils.typeOrSubTypeOf(fieldType, field.getType())) continue;
            foundFields.add(field);
        }
        if (objectValidatorFields.size() != foundFields.size()) {
            throw new IllegalStateException("Annotation @" + annotation.getName() + " can only be used on a type " + fieldType.getName() + " or its subclasses.");
        }
        return foundFields;
    }

    private static <T> boolean typeOrSubTypeOf(Class<T> fieldType, Class<?> classToCheck) {
        return classToCheck.isAssignableFrom(fieldType);
    }

    private static <T> boolean implementsType(Class<T> fieldType, Class<?> classToCheck) {
        return Arrays.asList(classToCheck.getInterfaces()).contains(fieldType);
    }

    public static ObjectValidationRulesCollection toRulesCollection(String rulesClassName) {
        try {
            return Utils.toRulesCollection(Class.forName(rulesClassName));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("The class " + rulesClassName + " was not found on the classpath.", classNotFoundException);
        }
    }

    public static EqualsHashCodeValidator toEqualsHashCodeValidator(Class<?> classToCast) {
        Utils.checkNotNull(classToCast, "Collection cannot be null");
        return Utils.toRulesCollection(classToCast).getEqualsHashCodeValidator();
    }

    public static ObjectValidationRulesCollection toRulesCollection(Class<?> classToCast) {
        Utils.checkNotNull(classToCast, "Collection cannot be null");
        Utils.checkArgument(!classToCast.isInterface(), "Collection must be an implementation");
        Utils.checkArgument(Utils.implementsType(ObjectValidationRulesCollection.class, classToCast), classToCast.getName() + " is does not implement the interface " + ObjectValidationRulesCollection.class.getName());
        return (ObjectValidationRulesCollection)Utils.instantiate(classToCast);
    }

    public static Object instantiate(Class<?> classToInstatiate) {
        try {
            return classToInstatiate.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(classToInstatiate.getName() + " cannot be instantiated.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(classToInstatiate.getName() + " cannot be accessed.", illegalAccessException);
        }
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }
}

