package org.unitils.objectvalidation;

import static junit.framework.Assert.assertNotNull;


/**
 * A description of error that happened on a class when validated.
 * 
 * @author Matthieu Mestrez
 * @since Nov 18, 2013
 */
public class ValidationMessage {

    private String validationMessage;
    private Class<?> rule;
    
    ValidationMessage(Class<?> rule, String validationMessage) {
        assertNotNull(rule);
        this.rule = rule;
        this.validationMessage = validationMessage;
    }
    
    String getValidationMessage() {
        return validationMessage;
    }
    
    Class<?> getRule() {
        return rule;
    }
    
    @Override
    public String toString() {
        return getRule().getName() + " : " + getValidationMessage();
    }
    
}