package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Random;

import org.unitils.util.ReflectionUtils;

/**
 * 
 * Generates an random enum from the right class.
 *
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class EnumGenerator implements Generator {

    private Random random = new Random(new Date().getTime());
    
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception {
        if (clazz.isEnum()) {
            return createEnum(clazz);
        }
        return null;
    }


    Object createEnum(Class<?> clazz) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Method method : ReflectionUtils.getAllMethods(clazz)) {
            if (method.getName().equals("values")) {
                Enum<?>[] values = (Enum[]) method.invoke(null, (Object[]) null);
                return values[random.nextInt(values.length)];
            }
        }
        throw new RuntimeException();
    }
}
