package org.unitils.objectvalidation.objectcreator.generator;

import java.util.List;


/**
 * A generator represents an object factory for the purpose of testing it against rules.
 * If the default provided generators returns null object you can define your own.
 * 
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public interface Generator {


    /**
     * @param clazz The class of the object to generate
     * @param input the parameters to give to the constructor
     * @param inputClasses the types of the constructor parameters
     * @return Object a randomly generated object or null if it was impossible to generate
     * @throws Exception if illegal calls to object constructors.
     */
    Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) throws Exception;


}
