/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.CompositeGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.objectvalidation.utils.TreeNodeCreator;

class ObjectCreatorImpl
implements ObjectCreator {
    private static final Logger LOGGER = Logger.getLogger("ObjectCreator");
    private Generator generator;

    ObjectCreatorImpl(Generator ... generators) {
        CompositeGenerator gen = new CompositeGenerator();
        gen.addGenerators(generators);
        this.generator = gen;
    }

    @Override
    public Object createRandomObject(Class<?> type) {
        TreeNode parentNode = TreeNodeCreator.createTreeNodeFor(type);
        return this.createFromTree(parentNode);
    }

    protected Object createFromTree(TreeNode parentNode) {
        ArrayList<Object> input = new ArrayList<Object>(parentNode.getChilds().size());
        ArrayList inputClasses = new ArrayList(parentNode.getChilds().size());
        for (TreeNode child : parentNode.getChilds()) {
            input.add(this.createFromTree(child));
            inputClasses.add(child.getValue());
        }
        try {
            return this.generator.generateObject(parentNode.getValue(), input, inputClasses);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Invocation on the generator has made a mistake. Try adding a custom generator for the object the factory has problems with.", e);
            return null;
        }
    }
}

