/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.junit.Assert;
import org.unitils.objectvalidation.Rule;
import org.unitils.util.ReflectionUtils;

public class ClassMustBeSerializableRule
implements Rule {
    @Override
    public void validate(Class<?> classToValidate) {
        Assert.assertTrue((String)"Class is not Serializable.", (boolean)(classToValidate instanceof Serializable));
        this.assertSerialsVersionUIDExists(classToValidate);
    }

    private void assertSerialsVersionUIDExists(Class<?> classToValidate) {
        Field field = ReflectionUtils.getFieldWithName(classToValidate, (String)"serialVersionUID", (boolean)true);
        Assert.assertNotNull((String)"Class does not contains serialVersionUID field.", (Object)field);
        Assert.assertTrue((String)"serialVersionUID is not final.", (boolean)Modifier.isFinal(field.getModifiers()));
        Assert.assertTrue((String)"serialVersionUID is not private", (boolean)Modifier.isPrivate(field.getModifiers()));
        Assert.assertTrue((String)"serialVersionUID is not static", (boolean)Modifier.isStatic(field.getModifiers()));
    }
}

