/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import org.junit.Assert;
import org.unitils.core.UnitilsException;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.Rule;

public class EqualsComplientRule
implements Rule {
    private static final int NUMBER_OF_EQUALS_CHECK_FOR_CONSISTENCY = 500;
    private ObjectCreator randomFactory;
    private ObjectCloner objectCloner;
    private Class<?> clazz;

    public EqualsComplientRule(ObjectCreator randomFactory, ObjectCloner objectCloner) {
        this.randomFactory = randomFactory;
        this.objectCloner = objectCloner;
    }

    @Override
    public void validate(Class<?> bean) {
        this.clazz = bean;
        Object firstInstance = this.randomFactory.createRandomObject(bean);
        Object secondInstance = this.objectCloner.deepClone(firstInstance);
        Object thirdInstance = this.objectCloner.deepClone(firstInstance);
        this.checkRules(firstInstance, secondInstance, thirdInstance);
    }

    private void checkRules(Object firstInstance, Object secondInstance, Object thirdInstance) {
        if (firstInstance == null || secondInstance == null) {
            throw new UnitilsException("One of the instances is null.");
        }
        this.testReflexive(firstInstance);
        this.testSymmetric(firstInstance, secondInstance);
        this.testTransitive(firstInstance, secondInstance, thirdInstance);
        this.testConsistent(firstInstance, secondInstance);
        this.testNonValue(firstInstance);
        this.testInequality(firstInstance);
        this.testInequalityWithARandomObject(firstInstance);
    }

    private void testReflexive(Object x) {
        Assert.assertTrue((String)"Equals is not reflexive.", (boolean)x.equals(x));
    }

    private void testSymmetric(Object x, Object y) {
        Assert.assertTrue((String)"Equals is not symmetric.", (boolean)x.equals(y));
        Assert.assertTrue((String)"Equals is not symmetric.", (boolean)y.equals(x));
    }

    private void testTransitive(Object x, Object y, Object z) {
        Assert.assertTrue((String)"Equals is not transitive.", (boolean)x.equals(y));
        Assert.assertTrue((String)"Equals is not transitive.", (boolean)y.equals(z));
        Assert.assertTrue((String)"Equals is not transitive.", (boolean)z.equals(x));
    }

    private void testConsistent(Object x, Object y) {
        for (int i = 0; i < 500; ++i) {
            Assert.assertTrue((String)"Equals is not consistent.", (boolean)x.equals(y));
        }
    }

    private void testNonValue(Object x) {
        Object nullObject = null;
        Assert.assertFalse((String)"Equals should not be equals to null for a non null object.", (boolean)x.equals(nullObject));
    }

    private void testInequality(Object x) {
        Object y = this.createDifferentObject(x);
        Assert.assertFalse((String)("Object " + x + " should not be equal with random object " + y), (boolean)x.equals(y));
    }

    private void testInequalityWithARandomObject(Object x) {
        Object y = new Object();
        Assert.assertFalse((String)("Object " + x + " should not be equal to " + y), (boolean)x.equals(y));
    }

    private Object createDifferentObject(Object previousValue) {
        Object randomField = this.randomFactory.createRandomObject(this.clazz);
        int maxSearchForRandom = 1000;
        while (previousValue == randomField || previousValue.equals(randomField)) {
            randomField = this.randomFactory.createRandomObject(previousValue.getClass());
            if (--maxSearchForRandom != 0) continue;
            Assert.fail((String)("The validator was unable to create a different value for the field " + previousValue.getClass() + " of the class " + this.clazz.getName() + " than " + randomField.toString()));
        }
        return randomField;
    }
}

