/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.Rule;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.util.ReflectionUtils;

public class GetterAndSetterComplientRule
implements Rule {
    private static final List<String> FIELDS_NAME_TO_IGNORE = Arrays.asList("serialVersionUID", "$jacocoData");
    private ObjectCreator objectCreator;
    private ObjectCloner objectCloner;

    public GetterAndSetterComplientRule(ObjectCreator objectCreator, ObjectCloner objectCloner) {
        this.objectCreator = objectCreator;
        this.objectCloner = objectCloner;
    }

    @Override
    public void validate(Class<?> classToValidate) {
        Object object = this.objectCreator.createRandomObject(classToValidate);
        if (object == null) {
            throw new AssertionError((Object)("Could not create object of type " + classToValidate.getName()));
        }
        this.loopOverFieldsAndCheckRules(object);
    }

    private void loopOverFieldsAndCheckRules(Object object) {
        for (Field field : ReflectionUtils.getAllFields(object.getClass())) {
            if (FIELDS_NAME_TO_IGNORE.contains(field.getName())) continue;
            Method getter = this.getGetterFor(field);
            Method setter = this.getSetterFor(field);
            Object objectValue = this.getValueIfFinal(field, object);
            Assert.assertNotNull((String)("No getter for the field " + field.getName()), (Object)getter);
            Assert.assertNotNull((String)("No setter for the field " + field.getName()), (Object)setter);
            this.handleGetter(object, field, objectValue);
            this.assertGetterIsComplient(field, objectValue, object, getter);
            this.handleSetter(object, setter, objectValue);
            this.assertSetterIsComplient(field, objectValue, object);
        }
    }

    private Method getGetterFor(Field field) {
        return ReflectionUtils.getGetter(field.getDeclaringClass(), (String)field.getName(), (boolean)false);
    }

    private Method getSetterFor(Field field) {
        return ReflectionUtils.getSetter(field.getDeclaringClass(), (String)field.getName(), (boolean)false);
    }

    private Object getValueIfFinal(Field field, Object object) {
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                field.setAccessible(true);
                return field.get(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)("field " + field.getName() + " had a wrong argument.\n" + illegalArgumentException.getMessage()));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)("field " + field.getName() + " could not be accessed.\n" + illegalAccessException.getMessage()));
            }
        }
        return this.objectCreator.createRandomObject(field.getType());
    }

    private Object handleGetter(Object simpleBean, Field field, Object value) {
        ReflectionUtils.setFieldValue((Object)simpleBean, (Field)field, (Object)value);
        return this.clone(value);
    }

    private Object handleSetter(Object simpleBean, Method method, Object value) {
        try {
            method.invoke(simpleBean, value);
        }
        catch (IllegalArgumentException exception) {
            this.throwAssertionError(simpleBean, method, exception);
        }
        catch (IllegalAccessException exception) {
            this.throwAssertionError(simpleBean, method, exception);
        }
        catch (InvocationTargetException exception) {
            this.throwAssertionError(simpleBean, method, exception);
        }
        return this.clone(value);
    }

    private void assertGetterIsComplient(Field field, Object value, Object simpleBean, final Method method) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
        try {
            ReflectionAssert.assertReflectionEquals((String)("Getter returned non equal value for field=[" + field + "]"), (Object)value, (Object)method.invoke(simpleBean, new Object[0]), (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
            ReflectionAssert.assertReflectionEquals((String)("Getter returned non equal value for field the second time=[" + field + "]"), (Object)value, (Object)method.invoke(simpleBean, new Object[0]), (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        }
        catch (AssertionFailedError e) {
            this.throwAssertionError(field, simpleBean, method, e);
        }
        catch (IllegalArgumentException e) {
            this.throwAssertionError(field, simpleBean, method, e);
        }
        catch (IllegalAccessException e) {
            this.throwAssertionError(field, simpleBean, method, e);
        }
        catch (InvocationTargetException e) {
            this.throwAssertionError(field, simpleBean, method, e);
        }
    }

    protected void assertSetterIsComplient(Field fieldEntry, Object actual, Object simpleBean) {
        ReflectionAssert.assertReflectionEquals((String)("Setter setted non equal value for field=[" + fieldEntry + "]"), (Object)actual, (Object)ReflectionUtils.getFieldValue((Object)simpleBean, (Field)fieldEntry), (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
    }

    private void throwAssertionError(Field field, Object simpleBean, Method method, Throwable exception) throws AssertionError {
        throw new AssertionError((Object)("The field " + field.getName() + " has a compliancy problem with his method " + method.getName() + ".\n" + exception.getMessage()));
    }

    private void throwAssertionError(Object simpleBean, Method method, Throwable exception) throws AssertionError {
        throw new AssertionError((Object)("The method " + method.getName() + " had a compliancy problem.\n" + exception.getMessage()));
    }

    private Object clone(Object value) {
        if (!Object.class.equals(value.getClass())) {
            return this.objectCloner.deepClone(value);
        }
        return value;
    }
}

