/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.utils;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.objectvalidation.utils.Utils;

public final class TreeNodeCreator {
    private TreeNodeCreator() {
    }

    public static final TreeNode createTreeNodeFor(Class<?> type) {
        TreeNode parentNode = new TreeNode(type);
        return TreeNodeCreator.fillInChildren(parentNode);
    }

    private static final TreeNode fillInChildren(TreeNode node) {
        Utils.checkNotNull(node, "The node cannot be null");
        Class<?> value = node.getValue();
        if (TreeNodeCreator.valueConsideredAsPrimitiveOrWithoutChildNodes(value)) {
            return node;
        }
        Constructor<?> constructor = TreeNodeCreator.figureOutConstructor(value, node);
        constructor.setAccessible(true);
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            TreeNode child = new TreeNode(parameterType);
            node.addChild(child);
            TreeNodeCreator.fillInChildren(child);
        }
        return node;
    }

    private static boolean valueConsideredAsPrimitiveOrWithoutChildNodes(Class<?> value) {
        return value.isEnum() || value.isInterface() || value.isArray() || value.isPrimitive() || Number.class.isAssignableFrom(value) || String.class.isAssignableFrom(value) || Collection.class.isAssignableFrom(value) || Boolean.class.isAssignableFrom(value) || Exception.class.isAssignableFrom(value);
    }

    private static Constructor<?> figureOutConstructor(Class<?> value, TreeNode parentNode) {
        List<Constructor<?>> constructors = Arrays.asList(value.getDeclaredConstructors());
        Collections.sort(constructors, new ConstructorSizeComparator());
        for (Constructor<?> constructor : constructors) {
            if (!TreeNodeCreator.isCyclycDependencyOk(constructor, parentNode) || !TreeNodeCreator.isNotGeneratedConstructor(constructor)) continue;
            return constructor;
        }
        throw new UnitilsException("Could not create object, no constructor found for class " + value.getName() + " with creation tree " + parentNode);
    }

    private static boolean isNotGeneratedConstructor(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }

    private static boolean isCyclycDependencyOk(Constructor<?> constructor, TreeNode parentNode) {
        for (Class<?> type : constructor.getParameterTypes()) {
            if (!TreeNodeCreator.isClassAlreadyInTheTree(type, parentNode)) continue;
            return false;
        }
        return true;
    }

    private static boolean isClassAlreadyInTheTree(Class<?> type, TreeNode node) {
        if (node == null) {
            return false;
        }
        if (type.equals(node.getValue())) {
            return true;
        }
        return TreeNodeCreator.isClassAlreadyInTheTree(type, node.getParent());
    }

    private static class ConstructorSizeComparator
    implements Comparator<Constructor<?>>,
    Serializable {
        private static final long serialVersionUID = -7354619453997861875L;

        private ConstructorSizeComparator() {
        }

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            return o2.getParameterTypes().length - o1.getParameterTypes().length;
        }
    }
}

