/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.utils.TreeNode;

public class CollectionGenerator
implements Generator {
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 10;

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(Map.class)) {
                if (genericSubTypes == null || genericSubTypes.size() != 2) {
                    throw new UnitilsException("Expected two generic parameters in the hashmap definition.");
                }
                HashMap hashMap = new HashMap();
                for (int i = 0; i < CollectionGenerator.numberOfObjectsToGenerate(); ++i) {
                    Object key = this.createRandomObject(genericSubTypes.get(0).getValue());
                    Object value = this.createRandomObject(genericSubTypes.get(1).getValue());
                    hashMap.put(key, value);
                }
                return hashMap;
            }
            if (clazz.isAssignableFrom(List.class)) {
                if (genericSubTypes == null || genericSubTypes.size() != 1) {
                    throw new UnitilsException("Expected one generic parameters in the List definition.");
                }
                return this.createListOf(genericSubTypes);
            }
            if (clazz.isAssignableFrom(Set.class)) {
                if (genericSubTypes == null || genericSubTypes.size() != 1) {
                    throw new UnitilsException("Expected one generic parameters in the Set definition.");
                }
                return new HashSet(this.createListOf(genericSubTypes));
            }
        }
        if (clazz.isArray()) {
            int objectsToGenerate = CollectionGenerator.numberOfObjectsToGenerate();
            Object[] array = (Object[])Array.newInstance(clazz.getComponentType(), objectsToGenerate);
            for (int i = 0; i < objectsToGenerate; ++i) {
                array[i] = this.createRandomObject(clazz.getComponentType());
            }
            return array;
        }
        return null;
    }

    private List createListOf(List<TreeNode> genericSubTypes) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < CollectionGenerator.numberOfObjectsToGenerate(); ++i) {
            list.add(this.createRandomObject(genericSubTypes.get(0).getValue()));
        }
        return list;
    }

    private <T> T createRandomObject(Class<T> clazz) {
        return (T)ObjectCreatorFactory.createDefaultObjectCreator().createRandomObject(clazz);
    }

    private static int numberOfObjectsToGenerate() {
        return 1 + (int)(Math.random() * 10.0);
    }
}

