/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.utils;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.objectvalidation.utils.Utils;

public final class TreeNodeCreator {
    private static final Logger LOGGER = Logger.getLogger(TreeNodeCreator.class.getName());

    private TreeNodeCreator() {
    }

    public static final TreeNode createTreeNodeFor(Type type) {
        TreeNode parentNode = new TreeNode(TreeNodeCreator.classForType(type));
        parentNode.setGenericSubtype(TreeNodeCreator.getGenericTypes(type));
        return TreeNodeCreator.fillInChildren(parentNode);
    }

    private static final TreeNode fillInChildren(TreeNode node) {
        Utils.checkNotNull(node, "The node cannot be null");
        Class<?> value = node.getValue();
        if (TreeNodeCreator.valueConsideredAsPrimitiveOrWithoutChildNodes(value)) {
            return node;
        }
        TreeNodeCreator.createNodeForConstructor(node);
        return node;
    }

    private static void createNodeForConstructor(TreeNode node) {
        Constructor<?> constructor = TreeNodeCreator.figureOutConstructor(node.getValue(), node);
        if (TreeNodeCreator.emptyOrNoConstructor(constructor)) {
            constructor.setAccessible(true);
            for (Type parameterType : constructor.getGenericParameterTypes()) {
                TreeNode child = new TreeNode(TreeNodeCreator.classForType(parameterType));
                child.setGenericSubtype(TreeNodeCreator.getGenericTypes(parameterType));
                node.addChild(child);
                TreeNodeCreator.fillInChildren(child);
            }
        }
    }

    private static Class<?> classForType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        LOGGER.warning("Objectvalidation does not yet handle type : " + type);
        return null;
    }

    private static List<TreeNode> getGenericTypes(Type parameterType) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        if (parameterType instanceof ParameterizedType) {
            Type[] arrayTypes;
            for (Type type : arrayTypes = ((ParameterizedType)parameterType).getActualTypeArguments()) {
                TreeNode node = TreeNodeCreator.createTreeNodeFor(type);
                treeNodes.add(node);
            }
        } else if (parameterType instanceof Class) {
            Class parameterClass = (Class)parameterType;
            if (parameterClass.isArray()) {
                TreeNode node = TreeNodeCreator.createTreeNodeFor(parameterClass.getComponentType());
                treeNodes.add(node);
            }
        } else {
            LOGGER.warning("TypeVariable " + parameterType.toString() + " is not fully managed in objectvalidation yet.");
        }
        return treeNodes;
    }

    private static boolean emptyOrNoConstructor(Constructor<?> constructor) {
        return constructor != null && constructor.getParameterTypes().length > 0;
    }

    private static boolean valueConsideredAsPrimitiveOrWithoutChildNodes(Class<?> value) {
        return value.isEnum() || value.isInterface() || value.isPrimitive() || value.isArray() || Number.class.isAssignableFrom(value) || String.class.isAssignableFrom(value) || Boolean.class.isAssignableFrom(value) || Collection.class.isAssignableFrom(value) || Exception.class.isAssignableFrom(value);
    }

    private static Constructor<?> figureOutConstructor(Class<?> value, TreeNode parentNode) {
        List<Constructor<?>> constructors = Arrays.asList(value.getDeclaredConstructors());
        Collections.sort(constructors, new ConstructorSizeComparator());
        for (Constructor<?> constructor : constructors) {
            if (!TreeNodeCreator.isCyclycDependencyOk(constructor, parentNode) || !TreeNodeCreator.isNotGeneratedConstructor(constructor)) continue;
            return constructor;
        }
        return null;
    }

    private static boolean isNotGeneratedConstructor(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }

    private static boolean isCyclycDependencyOk(Constructor<?> constructor, TreeNode parentNode) {
        for (Class<?> type : constructor.getParameterTypes()) {
            if (!TreeNodeCreator.isClassAlreadyInTheTree(type, parentNode)) continue;
            return false;
        }
        return true;
    }

    private static boolean isClassAlreadyInTheTree(Class<?> type, TreeNode node) {
        if (node == null) {
            return false;
        }
        if (type.equals(node.getValue())) {
            return true;
        }
        return TreeNodeCreator.isClassAlreadyInTheTree(type, node.getParent());
    }

    private static class ConstructorSizeComparator
    implements Comparator<Constructor<?>>,
    Serializable {
        private static final long serialVersionUID = -7354619453997861875L;

        private ConstructorSizeComparator() {
        }

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            return o2.getParameterTypes().length - o1.getParameterTypes().length;
        }
    }
}

