/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation;

import java.lang.reflect.Field;
import java.util.List;
import org.junit.Assert;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.util.ReflectionUtils;

public class EqualsHashCodeValidator {
    private ObjectCreator objectCreator;
    private ObjectCloner objectCloner;

    public EqualsHashCodeValidator(ObjectCreator objectCreator, ObjectCloner objectCloner) {
        this.objectCreator = objectCreator;
        this.objectCloner = objectCloner;
    }

    void validate(Class<?> classToValidate, List<Field> fields) {
        Object randomObject = this.objectCreator.createRandomObject(classToValidate);
        Object copy = this.objectCloner.deepClone(randomObject);
        Assert.assertEquals((String)"The object and its clone are expected to be equals", (Object)randomObject, (Object)copy);
        Assert.assertEquals((String)"The object and its clone hashCodes are expected to be equals", (long)randomObject.hashCode(), (long)copy.hashCode());
        for (Field field : fields) {
            if (!this.fieldCanBeCompared(field)) continue;
            Object randomField = this.objectCreator.createRandomObject(field.getGenericType());
            int maxSearchForRandom = 1000;
            Object previousValue = ReflectionUtils.getFieldValue((Object)randomObject, (Field)field);
            while (previousValue.equals(randomField) && randomField != null) {
                randomField = this.objectCreator.createRandomObject(field.getGenericType());
                if (--maxSearchForRandom != 0) continue;
                Assert.fail((String)("The validator was unable to create a different value for the field " + field.getName() + " of the class " + classToValidate.getName() + " than " + randomField.toString()));
            }
            ReflectionUtils.setFieldValue((Object)copy, (Field)field, (Object)randomField);
            Assert.assertFalse((String)("Changing the field " + field.getName() + " of the class " + classToValidate.getName() + " from '" + previousValue + "' to '" + randomField.toString() + "' still makes it an equals object. It is expected to be false."), (boolean)randomObject.equals(copy));
            if (field.getType().isPrimitive()) continue;
            ReflectionUtils.setFieldValue((Object)copy, (Field)field, null);
            Assert.assertFalse((String)("Changing the field " + field.getName() + " of the class " + classToValidate.getName() + " from '" + previousValue + "' to 'null' still makes it an equals object. It is expected to be false."), (boolean)randomObject.equals(copy));
        }
    }

    private boolean fieldCanBeCompared(Field field) {
        return field.getName() != "serialVersionUID" && field.getName() != "$jacocoData";
    }
}

