package org.unitils.objectvalidation.objectcreator;

import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.DefaultGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;

/**
 * Creates {@link org.unitils.objectvalidation.ObjectCreator} used to create objects for the {@link org.unitils.objectvalidation.Rule}.
 * 
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class ObjectCreatorFactory {
    
    private ObjectCreatorFactory() { }

    public static ObjectCreator createObjectCreator(Generator... generators) {
        return new ObjectCreatorImpl(generators);
    }

    public static ObjectCreator createDefaultObjectCreator() {
        return createObjectCreator(new DefaultGenerator());
    }

}
