/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.unitils.core.UnitilsException;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.CompositeGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.objectvalidation.utils.TreeNodeCreator;
import org.unitils.util.ReflectionUtils;

class ObjectCreatorImpl
implements ObjectCreator {
    private static final Logger LOGGER = Logger.getLogger("ObjectCreator");
    private Generator generator;

    ObjectCreatorImpl(Generator ... generators) {
        CompositeGenerator gen = new CompositeGenerator();
        gen.addGenerators(generators);
        this.generator = gen;
    }

    @Override
    public Object createRandomObject(Type type) {
        TreeNode parentNode = TreeNodeCreator.createTreeNodeFor(type);
        Object randomObject = this.createFromTree(parentNode);
        this.fillInNullFields(randomObject);
        return randomObject;
    }

    private void fillInNullFields(Object randomObject) {
        if (randomObject != null) {
            Set fields = ReflectionUtils.getAllFields(randomObject.getClass());
            for (Field field : fields) {
                try {
                    if (Modifier.isStatic(field.getModifiers()) || ReflectionUtils.getFieldValue((Object)randomObject, (Field)field) != null) continue;
                    Object fieldValue = this.createRandomObject(field.getGenericType());
                    ReflectionUtils.setFieldValue((Object)randomObject, (Field)field, (Object)fieldValue);
                }
                catch (IllegalArgumentException e) {
                    throw new UnitilsException("Field " + field.getName() + " value could not be retrieved.", (Throwable)e);
                }
            }
        }
    }

    protected Object createFromTree(TreeNode parentNode) {
        ArrayList<Object> input = new ArrayList<Object>(parentNode.getChilds().size());
        ArrayList inputClasses = new ArrayList(parentNode.getChilds().size());
        for (TreeNode child : parentNode.getChilds()) {
            input.add(this.createFromTree(child));
            inputClasses.add(child.getValue());
        }
        try {
            return this.generator.generateObject(parentNode.getValue(), input, inputClasses, parentNode.getGenericSubtype());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Invocation on the generator has made a mistake. Try adding a custom generator for the object '" + parentNode.getValue().getName() + "' the factory has problems with.", e);
            return null;
        }
    }
}

