package org.unitils.objectvalidation;

import java.lang.reflect.Type;


/**
 * The responsability of {@link ObjectCreator} is to create object of the type provided.
 * 
 * The default ones are :
 * 1. {@link org.unitils.objectvalidation.objectcreator.generator.EnumGenerator} : That will generate a random enumeration.
 * 
 * 2. {@link org.unitils.objectvalidation.objectcreator.generator.PrimitiveGenerator} : That will handle all those field types :
 *    - int, {@link Integer}, boolean, {@link Boolean}, float, {@link Float}, double, {@link Double},
 *      {@link java.math.BigDecimal}, long, {@link Long}, short, {@link Short}, byte, {@link Byte}
 *    - char, {@link Character}, {@link String}
 *    - {@link java.util.Date}, {@link java.sql.Date}, {@link java.sql.Timestamp}, {@link java.util.Calendar}
 *    - Subtype of {@link Exception}
 * 
 * 3. {@link org.unitils.objectvalidation.objectcreator.generator.CollectionGenerator} :
 *    - It will handle the classes assignables from : {@link java.util.Map}, {@link java.util.Set}, {@link java.util.List} and the arrays
 *    - It will go down the tree even if types like this : HashMap<String, HashMap<String, List<String>>>
 *    - It will generate for each of those field a random number of items between 1 and 10.
 * 
 * 4. {@link org.unitils.objectvalidation.objectcreator.generator.BuilderGenerator} :
 *    - It will check if the class specifies a "build" method and will fill in the Builder object fields by reflection.
 * 
 * 5. {@link org.unitils.objectvalidation.objectcreator.generator.LastResortGenerator} :
 *    - It will generate the class through reflection, using all the fields collected by the {@link org.unitils.objectvalidation.utils.TreeNodeCreator}.
 * 
 * @author Matthieu Mestrez
 * @since Oct 18, 2013
 */
public interface ObjectCreator {

    Object createRandomObject(Type bean);

}
