package org.unitils.objectvalidation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;


/**
 * Annotation to be used in the context of the validation module.
 * Annotation should be put on an Object of type Object
 * 
 * @author Matthieu Mestrez
 * @since Oct 9, 2013
 */
@Retention(RUNTIME)
@Target(FIELD)
public @interface ObjectValidationRules {

    /**
     * <b>Optional</b>
     * @return additional rules (than the ones defined in the properties file)
     * that are going to be run on the class to validate.
     */
    Class<? extends ObjectValidationRulesCollection>[] additionalRules() default {};

    /**
     * <b>Optional</b>
     * @return replacement rules if there is a desire to not run the validation
     * rules globally defined in the properties file.
     */
    Class<? extends ObjectValidationRulesCollection>[] replacementRules() default {};
    
}
