package org.unitils.objectvalidation.rulescollection;

import java.util.ArrayList;
import java.util.List;

import org.unitils.objectvalidation.EqualsHashCodeValidator;
import org.unitils.objectvalidation.ObjectValidationRulesCollection;
import org.unitils.objectvalidation.Rule;
import org.unitils.objectvalidation.rules.ClassIsFinalRule;
import org.unitils.objectvalidation.rules.OnlyStaticMethodsRule;
import org.unitils.objectvalidation.rules.PrivateConstructorRule;


/**
 * Collection of rules for an utility class.
 * A utility class should :
 * 1. Only have one private constructor : {@link PrivateConstructorRule}
 * 2. Only have static methods : {@link OnlyStaticMethodsRule}
 * 3. Be final : {@link ClassIsFinalRule}
 * 
 * @author Matthieu Mestrez
 * @since Oct 23, 2013
 */
public class UtilityClassRules implements ObjectValidationRulesCollection {

    @Override
    public List<Rule> getRules() {
        List<Rule> rules = new ArrayList<Rule>();
        
        rules.add(new PrivateConstructorRule());
        rules.add(new OnlyStaticMethodsRule());
        rules.add(new ClassIsFinalRule());
        
        return rules;
    }

    @Override
    /** Should not be used to validate equals and hashCode on a utility class. */
    public EqualsHashCodeValidator getEqualsHashCodeValidator() {
        return null;
    }

}
