/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.util.ReflectionUtils;

public class EqualsHashCodeValidator {
    private static final Logger LOGGER = Logger.getLogger("org.unitils.objectvalidation");
    private ObjectCreator objectCreator;
    private ObjectCloner objectCloner;

    public EqualsHashCodeValidator(ObjectCreator objectCreator, ObjectCloner objectCloner) {
        this.objectCreator = objectCreator;
        this.objectCloner = objectCloner;
    }

    void validate(Class<?> classToValidate, List<Field> fields) {
        Object randomObject = this.objectCreator.createRandomObject(classToValidate);
        Object copy = this.objectCloner.deepClone(randomObject);
        Assert.assertEquals((String)"The object and its clone are expected to be equals", (Object)randomObject, (Object)copy);
        Assert.assertEquals((String)"The object and its clone hashCodes are expected to be equals", (long)randomObject.hashCode(), (long)copy.hashCode());
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object object = this.createDifferentObjectThan(field, randomObject);
            junit.framework.Assert.assertFalse((String)("Objects were supposed to be different when changing field " + classToValidate.getName() + "." + field.getName() + " to another value : \nObject 1 : " + randomObject + " \nObject 2 : " + object), (boolean)randomObject.equals(object));
            if (field.getType().isPrimitive()) continue;
            Object objectWithNullField = this.createObjectWithFieldNull(field, randomObject);
            junit.framework.Assert.assertFalse((String)("Objects were supposed to be different when changing field " + classToValidate.getName() + "." + field.getName() + " to null : \nObject 1 : " + randomObject + " \nObject 2 : " + objectWithNullField), (boolean)randomObject.equals(objectWithNullField));
        }
    }

    private Object createDifferentObjectThan(Field field, Object randomObject) {
        Object randomField = this.objectCreator.createRandomObject(field.getGenericType());
        int maxSearchForRandom = 1000;
        Object differentObject = this.objectCloner.deepClone(randomObject);
        Object previousValue = ReflectionUtils.getFieldValue((Object)randomObject, (Field)field);
        while (this.sameValues(previousValue, randomField)) {
            randomField = this.objectCreator.createRandomObject(field.getGenericType());
            if (--maxSearchForRandom != 0) continue;
            Assert.fail((String)("The validator was unable to create a different value for the field " + field.getName() + " of the class " + field.getDeclaringClass().getName() + " than " + randomField.toString()));
        }
        ReflectionUtils.setFieldValue((Object)differentObject, (Field)field, (Object)randomField);
        return differentObject;
    }

    private Object createObjectWithFieldNull(Field field, Object randomObject) {
        Object differentObject = this.objectCloner.deepClone(randomObject);
        ReflectionUtils.setFieldValue((Object)differentObject, (Field)field, null);
        return differentObject;
    }

    private boolean sameValues(Object previousValue, Object randomField) {
        return (this.primitiveEquals(previousValue, randomField) || this.arrayEquals(previousValue, randomField) || previousValue.equals(randomField)) && randomField != null;
    }

    private boolean primitiveEquals(Object previousValue, Object randomField) {
        return previousValue.getClass().isPrimitive() && previousValue == randomField;
    }

    private boolean arrayEquals(Object previousValue, Object randomField) {
        if (previousValue.getClass().isArray()) {
            Class<Object> c = previousValue.getClass();
            if (!c.getComponentType().isPrimitive()) {
                c = Object[].class;
            }
            try {
                Method m = Arrays.class.getMethod("equals", c, c);
                return (Boolean)m.invoke(null, previousValue, randomField);
            }
            catch (SecurityException e) {
                LOGGER.log(Level.SEVERE, "SecurityException when trying to access Arrays.equals method", e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.log(Level.SEVERE, "NoSuchMethodException when trying to access Arrays.equals method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Arguments when invoking Arrays.equals method are wrong", e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "IllegalAccessException when invoking Arrays.equals", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "InvocationTargetException when invoking Arrays.equals", e);
            }
        }
        return false;
    }
}

