/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.util.ReflectionUtils;

public class BuilderGenerator
implements Generator {
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        try {
            clazz.getDeclaredMethod("build", new Class[0]);
            return this.fillInFields(clazz, input, inputClasses);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return null;
    }

    private Object fillInFields(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) {
        Set fields = ReflectionUtils.getAllFields(clazz);
        ObjectCreator objectCreator = ObjectCreatorFactory.createDefaultObjectCreator();
        Object builder = this.newBuilder(clazz, input, inputClasses);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object fieldValue = objectCreator.createRandomObject(field.getGenericType());
            ReflectionUtils.setFieldValue((Object)builder, (Field)field, (Object)fieldValue);
        }
        return builder;
    }

    private Object newBuilder(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) {
        try {
            if (input != null && !input.isEmpty() && !inputClasses.isEmpty()) {
                Class[] inputTypes = inputClasses.toArray(new Class[inputClasses.size()]);
                return ReflectionUtils.createInstanceOfType(clazz, (boolean)false, (Class[])inputTypes, (Object[])input.toArray());
            }
            return clazz.newInstance();
        }
        catch (InstantiationException exception) {
            throw new AssertionError((Object)("Builder for " + clazz.getName() + " could not be instantiated" + exception.getMessage()));
        }
        catch (IllegalAccessException exception) {
            throw new AssertionError((Object)("Builder for " + clazz.getName() + " could not be instantiated" + exception.getMessage()));
        }
    }
}

