package org.unitils.objectvalidation;

import java.lang.reflect.Type;

import org.unitils.objectvalidation.objectcreator.generator.Generator;


/**
 * The responsability of {@link ObjectCreator} is to create object of the type provided.
 * 
 * The default ones are :
 * <ol>
 *  <li> {@link org.unitils.objectvalidation.objectcreator.generator.EnumGenerator} : That will generate a random enumeration.</li>
 * 
 * <li> {@link org.unitils.objectvalidation.objectcreator.generator.PrimitiveGenerator} : That will handle all those field types :
 * 
 *  <ul>
 *    <li> int, {@link Integer}, boolean, {@link Boolean}, float, {@link Float}, double, {@link Double},
 *      {@link java.math.BigDecimal}, long, {@link Long}, short, {@link Short}, byte, {@link Byte}</li>
 *    <li> char, {@link Character}, {@link String}</li>
 *    <li> {@link java.util.Date}, {@link java.sql.Date}, {@link java.sql.Timestamp}, {@link java.util.Calendar}</li>
 *    <li>Subtype of {@link Exception}</li>
 *  </ul>
 * </li>
 * <li> {@link org.unitils.objectvalidation.objectcreator.generator.CollectionGenerator} :
 *  <ul>
 *    <li> It will handle the classes assignables from : {@link java.util.Map}, {@link java.util.Set}, {@link java.util.List} and the arrays </li>
 *    <li> It will go down the tree even if types like this : HashMap&lt;String, HashMap&lt;String, List&lt;String&gt;&gt;&gt;</li>
 *    <li> It will generate for each of those field a random number of items between 1 and 10.</li>
 *  </ul>
 * </li>
 * <li>{@link org.unitils.objectvalidation.objectcreator.generator.BuilderGenerator} :
 *    <ul>
 *    <li> It will check if the class specifies a "build" method and will fill in the Builder object fields by reflection.</li>
 *    </ul>
 *    
 * </li>
 * <li>
 * 
 * {@link org.unitils.objectvalidation.objectcreator.generator.LastResortGenerator} :
 * <ul>
 * <li>
 *    It will generate the class through reflection, using all the fields collected by the {@link org.unitils.objectvalidation.utils.TreeNodeCreator}.
 *  </li>
 *  </ul>
 *  </li>
 * </ol>
 * @author Matthieu Mestrez
 * @since Oct 18, 2013
 */
public interface ObjectCreator {

    Object createRandomObject(Type bean);

    void addGenerators(Generator... generator);
}
