package org.unitils.objectvalidation;

import static org.unitils.objectvalidation.utils.Utils.toRulesCollection;

import java.util.Properties;

import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.objectvalidation.rulescollection.SunBeanRules;


/**
 * Module to validate class against rules, it could be one of the rules 
 * defined in the org.unitils.objectvalidation.rules package
 * but could be also user implemented rules for other purpose.
 * 
 * Helpful in the case we want to have a project wide rule validator for classes. Simple to use with annotations.
 * 
 * @author Matthieu Mestrez
 * @since Oct 8, 2013
 */
public class ValidationModule implements Module {

    private static final String RULES_CLASS_DEFAULT_RULES = SunBeanRules.class.getName();
    private static final String RULES_CLASS_PROPERTY_KEY = "org.unitils.objectvalidation.rules.collection";

    private ObjectValidationRulesCollection validationRules;
    
    @Override
    public void init(Properties configuration) {
        String rulesClassName = configuration.getProperty(RULES_CLASS_PROPERTY_KEY, RULES_CLASS_DEFAULT_RULES);
        validationRules = toRulesCollection(rulesClassName);
    }

    @Override
    public void afterInit() { }

    @Override
    public TestListener getTestListener() {
        return new ValidationModuleTestListener(validationRules);
    }

}
