package org.unitils.objectvalidation.objectcreator;

import java.util.Properties;
import org.unitils.core.Unitils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.DefaultGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.util.PropertyUtils;

/**
 * Creates {@link org.unitils.objectvalidation.ObjectCreator} used to create objects for the {@link org.unitils.objectvalidation.Rule}.
 * 
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class ObjectCreatorFactory {
    
    private static final String PROPKEY_OBJECTCREATOR= "org.unitils.objectvalidation.objectcreator";
    
    private ObjectCreatorFactory() { }

    public static ObjectCreator createObjectCreator(Generator... generators) {
        return new ObjectCreatorImpl(generators);
    }

    public static ObjectCreator createDefaultObjectCreator() {
        ObjectCreator objCreator = PropertyUtils.getInstance(PROPKEY_OBJECTCREATOR, new ObjectCreatorImpl(), getUnitilsConfiguration());
        objCreator.addGenerators(new DefaultGenerator(objCreator));
        return objCreator;
    }
    
    protected static Properties getUnitilsConfiguration() {
        return Unitils.getInstance().getConfiguration();
    }
    
    protected static ObjectCreatorImpl createObjectCreator() {
        return new ObjectCreatorImpl();
    }

    public static ObjectCreator createMocksObjectCreator() {
    	return new ObjectCreatorMockedFieldsImpl();
    }
}
