package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.util.ReflectionUtils;


/**
 * @author Matthieu Mestrez
 * @since Nov 12, 2013
 */
public class BuilderGenerator implements Generator {

    private ObjectCreator objectCreator;

    /***/
    public BuilderGenerator() {
        super();
        this.objectCreator = ObjectCreatorFactory.createMocksObjectCreator();
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        try {
            clazz.getDeclaredMethod("build");
            return fillInFields(clazz, input, inputClasses);
        } catch (NoSuchMethodException e) {
        } catch (SecurityException e) {
        } catch (NullPointerException e) {
        }
        return null;
    }

    private Object fillInFields(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) {

        Set<Field> fields = ReflectionUtils.getAllFields(clazz);

        Object builder = newBuilder(clazz, input, inputClasses);

        for (Field field : fields) {

            if (!Modifier.isStatic(field.getModifiers())) {

                Object fieldValue = objectCreator.createRandomObject(field.getGenericType());
                ReflectionUtils.setFieldValue(builder, field, fieldValue);

            }
        }

        return builder;

    }

    private Object newBuilder(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses) {

        try {
            if (input != null && !input.isEmpty() && !inputClasses.isEmpty()) {
                Class<?>[] inputTypes = inputClasses.toArray(new Class<?>[inputClasses.size()]);
                return ReflectionUtils.createInstanceOfType(clazz, false, inputTypes, input.toArray());
            }
            return clazz.newInstance();
        } catch (InstantiationException exception) {
            throw new AssertionError("Builder for " + clazz.getName() + " could not be instantiated" + exception.getMessage());
        } catch (IllegalAccessException exception) {
            throw new AssertionError("Builder for " + clazz.getName() + " could not be instantiated" + exception.getMessage());
        }
    }
}
