package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.utils.TreeNode;

/**
 * This generator will take care of interfaces and the classes that have no
 * custom generator.
 *
 * "Cut this object into pieces this is your last resort! "
 *
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class CollectionGenerator implements Generator {

    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 10;

    private final ObjectCreator objectCreator;
    
    private final GenericsGenerator genericsGenerator;

    public CollectionGenerator() {
        this.objectCreator = ObjectCreatorFactory.createMocksObjectCreator();
    	this.genericsGenerator = new GenericsGenerator();
    }

    @SuppressWarnings({
        "unchecked", "rawtypes"
    })
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {

        if (clazz.isInterface()) {

            if (clazz.isAssignableFrom(Map.class)) {

                /*if (genericSubTypes == null || genericSubTypes.size() != 2) {
                    throw new UnitilsException("Expected two generic parameters in the hashmap definition.");
                }*/

                Map<Object, Object> hashMap = new HashMap<Object, Object>();

                for (int i = 0; i < numberOfObjectsToGenerate(); i++) {

                    Object key = createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(0).getValue());
                    Object value = createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(1).getValue());

                    hashMap.put(key, value);
                }

                return hashMap;
            }

            if (clazz.isAssignableFrom(List.class)) {

                /*if (genericSubTypes == null || genericSubTypes.size() != 1) {
                    throw new UnitilsException("Expected one generic parameters in the List definition.");
                }*/

                return createListOf(genericSubTypes.isEmpty() ? new TreeNode(Object.class) : genericSubTypes.get(0));
            }
            if (clazz.isAssignableFrom(Set.class)) {

                if (CollectionUtils.isEmpty(genericSubTypes)) {
                    //throw new UnitilsException("Expected one generic parameters in the Set definition.");
                    return new HashSet<Object>(createListOf(new TreeNode(Object.class)));
                }

                return new HashSet(createListOf(genericSubTypes.get(0)));
            }
        }

        if (clazz.isArray()) {

            /*if (genericSubTypes == null || genericSubTypes.size() != 1) {
                throw new UnitilsException("Expected one generic parameters in the array definition.");
            }*/

            TreeNode node = genericSubTypes.isEmpty() ? new TreeNode(Object.class) : genericSubTypes.get(0);
            List listOfObjects = createListOf(node);

            Object newInstance = Array.newInstance(node.getValue(), listOfObjects.size());
            for (int i = 0; i < listOfObjects.size(); i++) {

                Array.set(newInstance, i, listOfObjects.get(i));

            }

            return newInstance;
        }

        return null;
    }

    @SuppressWarnings({
        "unchecked", "rawtypes"
    })
    private List createListOf(TreeNode genericSubTypes) throws Exception {
        List list = new ArrayList();

        for (int i = 0; i < numberOfObjectsToGenerate(); i++) {
            Object obj = genericsGenerator.generateObject(genericSubTypes.getValue(), null, null, Arrays.asList(genericSubTypes));
            if (obj == null) {
                obj = objectCreator.createRandomObject(genericSubTypes.getValue());
            }
            list.add(obj);
        }
        return list;
    }
    

    @SuppressWarnings("unchecked")
    private <T> T createRandomObject(Class<T> clazz) {
        if (clazz == null) {
            return (T) objectCreator.createRandomObject(Object.class);
        }
        return (T) objectCreator.createRandomObject(clazz);

    }

    private static int numberOfObjectsToGenerate() {
        return MINIMUM + (int) (Math.random() * ((MAXIMUM - MINIMUM) + 1));
    }

}
