package org.unitils.objectvalidation.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.unitils.objectvalidation.reflect.TypeWrapper;

/**
 * @author Matthieu Mestrez
 * @since 07/03/14.
 */
public class ObjectCreatorTypeWrapper extends TypeWrapper {

    public ObjectCreatorTypeWrapper(Type type) {
        super(type);
        if (type == null) {
            throw new NullPointerException("TreeNode cannot be constructed with a null value");
        }
    }

    public Class<?> getTypeOfArray() {
        return ((Class<?>) getWrappedType()).getComponentType();
    }

    public Class<?> getTypeOfSingleParameterCollection() {
        if (isArray()) {
            return getTypeOfArray();
        }

        if (isList() || isSet()) {
            return getSingleGenericClass();
        }

        return null;
    }

    public Type getTypeForKeyOfMap() {
        if (isMap()) {
            Type[] types = ((ParameterizedType) wrappedType).getActualTypeArguments();

            return types[0];
        }
        return null;
    }

    public Type getTypeForValueOfMap() {
        if (isMap()) {
            Type[] types = ((ParameterizedType) wrappedType).getActualTypeArguments();

            return types[1];
        }
        return null;
    }

    public Class<?> getClassOfType() {
        if (isArray()) {
            return getTypeOfArray();
        }

        if (isClassType()) {
            return (Class<?>) getWrappedType();
        }

        if (isParameterizedType()) {
            return (Class<?>) ((ParameterizedType) getWrappedType()).getRawType();
        }

        return null;
    }

    public boolean isArray() {
        return isClassType() && ((Class<?>) getWrappedType()).isArray();
    }

    public boolean isList() {
        return  hasRawType(List.class);
    }

    public boolean isSet() {
        return hasRawType(Set.class);
    }

    public boolean isMap() {
        return hasRawType(Map.class);
    }

    protected boolean isEnum() {
        return isClassType() && getClassOfType().isEnum();
    }

    public boolean isInterface() {
        return isClassType() && getClassOfType().isInterface();
    }

    public boolean isException() {
        return isAssignableTo(Exception.class);
    }

    public boolean isUtilDate() {
        return Date.class.equals(getWrappedType());
    }

    public boolean isSQLDate() {
        return java.sql.Date.class.equals(getWrappedType());
    }

    public boolean isBoolean() {
        return isAssignableTo(Boolean.class) || isAssignableTo(boolean.class);
    }

    public boolean isString() {
        return isAssignableTo(String.class);
    }

    protected boolean isNumber() {
        return isAssignableTo(Number.class);
    }

}
