package org.unitils.objectvalidation.utils;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;


/**
 * Represents the hierarchy of a specific class, with his parent node and his child nodes.
 * 
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class TreeNode {

    private static final String IDENTATION = "   ";

    private Class<?> value;

    private TreeNode parent;

    private List<TreeNode> childs;
    private List<TreeNode> genericSubtype = new ArrayList<TreeNode>();
    
    private ParameterizedType parameterizedType;

    public TreeNode(Class<?> value) {
        this.value = value;
        childs = new LinkedList<TreeNode>();
    }
    
    public void addChild(TreeNode child) {
        child.setParent(this);
        childs.add(child);
    }

    public TreeNode addChild(Class<?> child) {
        TreeNode node = new TreeNode(child);
        addChild(node);
        return node;
    }
    
    public void setGenericSubtype(List<TreeNode> genericSubtype) {
        this.genericSubtype = genericSubtype;
    }
    
    public List<TreeNode> getGenericSubtype() {
        return genericSubtype;
    }

    public Class<?> getValue() {
        return value;
    }

    public TreeNode getParent() {
        return parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChilds() {
        return childs;
    }

    public ParameterizedType getParameterizedType() {
        return parameterizedType;
    }

    public void setParameterizedType(ParameterizedType parameterizedType) {
        this.parameterizedType = parameterizedType;
    }
    
    

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("\n");
        return toString(this, builder, "").toString();
    }

    public StringBuilder toString(TreeNode node, StringBuilder builder, String idents) {

        builder.append(idents).append("->").append(node.getValue().getName()).append("\n");

        for (TreeNode child : node.getChilds()) {
            toString(child, builder, idents + IDENTATION);
        }

        return builder;
    }

}
