/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.unitils.objectvalidation.EqualsHashCodeValidator;
import org.unitils.objectvalidation.Rule;
import org.unitils.objectvalidation.ValidationMessage;
import org.unitils.objectvalidation.ValidationResult;
import org.unitils.objectvalidation.utils.Utils;
import org.unitils.util.ReflectionUtils;

public class ObjectValidator {
    private List<Rule> rulesToValidate;
    private List<EqualsHashCodeValidator> equalsHashCodeValidators;

    public ObjectValidator(List<Rule> rulesToValidate, List<EqualsHashCodeValidator> equalsHashCodeValidators) {
        Utils.checkNotNull(rulesToValidate, "The list of rules cannot be null");
        Utils.checkNotNull(equalsHashCodeValidators, "The equals and hashCode validator cannot be null");
        this.rulesToValidate = rulesToValidate;
        this.equalsHashCodeValidators = equalsHashCodeValidators;
    }

    private void validate(ClassToValidate classToValidate) {
        ValidationResult validationResult = this.doValidate(classToValidate);
        if (!validationResult.isValid()) {
            throw new AssertionError((Object)validationResult.toString());
        }
    }

    private ValidationResult doValidate(ClassToValidate classToValidate) {
        ValidationResult.ValidationResultBuilder validationResultBuilder = ValidationResult.buildValidationResultForClass(classToValidate.getClassToValidate());
        for (Rule rule : this.rulesToValidate) {
            try {
                rule.validate(classToValidate.getClassToValidate());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                validationResultBuilder.andMessage(new ValidationMessage(rule.getClass(), throwable.getMessage()));
            }
        }
        if (classToValidate.hasToValidateEqualsAndHashCode()) {
            for (EqualsHashCodeValidator equalsHashCodeValidator : this.equalsHashCodeValidators) {
                try {
                    equalsHashCodeValidator.validate(classToValidate.getClassToValidate(), classToValidate.getFieldsToValidate());
                }
                catch (Throwable throwable) {
                    validationResultBuilder.andMessage(new ValidationMessage(equalsHashCodeValidator.getClass(), throwable.getMessage()));
                }
            }
        }
        return validationResultBuilder.build();
    }

    public ValidateEqualsAndHashCode classToValidate(Class<?> classToValidate) {
        return new BuildValidator(classToValidate, this);
    }

    private static class ClassToValidate {
        private Class<?> classToValidate;
        private List<Field> fieldsToValidate;
        private boolean validateEqualsAndHashCode;

        public ClassToValidate(Class<?> classToValidate) {
            this.classToValidate = classToValidate;
        }

        public void dontValidateEqualsAndHashCode() {
            this.validateEqualsAndHashCode = false;
        }

        public boolean hasToValidateEqualsAndHashCode() {
            return this.validateEqualsAndHashCode;
        }

        public void validateEqualsAndHashCode() {
            this.validateEqualsAndHashCode = true;
        }

        public void setFieldsToValidate(List<Field> fieldsToValidate) {
            this.fieldsToValidate = fieldsToValidate;
        }

        public Class<?> getClassToValidate() {
            return this.classToValidate;
        }

        public List<Field> getFieldsToValidate() {
            return this.fieldsToValidate;
        }
    }

    public class BuildValidator
    implements ValidateEqualsAndHashCode,
    ChooseFieldsInEquals,
    AddClassToValidate {
        private List<ClassToValidate> classesToValidate;
        private ClassToValidate classToValidateToAdd;
        private ObjectValidator objectValidator;

        BuildValidator(Class<?> classToValidate, ObjectValidator objectValidator2) {
            Assert.assertNotNull(classToValidate);
            Assert.assertNotNull((String)"The objectValidator seems not initialized, @RunWith(UnitilsJUnit4TestClassRunner.class) and unitils.properties configuration has to be done", (Object)objectValidator2);
            this.classesToValidate = new ArrayList<ClassToValidate>();
            this.classToValidateToAdd = new ClassToValidate(classToValidate);
            this.objectValidator = objectValidator2;
        }

        @Override
        public AddClassToValidate withFieldNames(String ... fieldNames) {
            ArrayList<Field> fields = new ArrayList<Field>();
            List<String> fieldsToValidate = Arrays.asList(fieldNames);
            for (Field field : ReflectionUtils.getAllFields(this.classToValidateToAdd.getClassToValidate())) {
                if (!fieldsToValidate.contains(field.getName())) continue;
                fields.add(field);
            }
            this.classToValidateToAdd.setFieldsToValidate(fields);
            this.classesToValidate.add(this.classToValidateToAdd);
            return this;
        }

        @Override
        public AddClassToValidate ignoringFields(String ... fieldNames) {
            ArrayList<Field> fields = new ArrayList<Field>();
            List<String> fieldsToValidate = Arrays.asList(fieldNames);
            for (Field field : ReflectionUtils.getAllFields(this.classToValidateToAdd.getClassToValidate())) {
                if (fieldsToValidate.contains(field.getName())) continue;
                fields.add(field);
            }
            this.classToValidateToAdd.setFieldsToValidate(fields);
            this.classesToValidate.add(this.classToValidateToAdd);
            return this;
        }

        @Override
        public AddClassToValidate withAllFields() {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Field field : ReflectionUtils.getAllFields(this.classToValidateToAdd.getClassToValidate())) {
                fields.add(field);
            }
            this.classToValidateToAdd.setFieldsToValidate(fields);
            this.classesToValidate.add(this.classToValidateToAdd);
            return this;
        }

        @Override
        public ValidateEqualsAndHashCode classToValidate(Class<?> classToValidate) {
            this.classToValidateToAdd = new ClassToValidate(classToValidate);
            return this;
        }

        @Override
        public void validate() {
            for (ClassToValidate classToValidate : this.classesToValidate) {
                this.objectValidator.validate(classToValidate);
            }
        }

        @Override
        public AddClassToValidate withoutCheckingAllPossibilities() {
            this.classToValidateToAdd.dontValidateEqualsAndHashCode();
            this.classesToValidate.add(this.classToValidateToAdd);
            return this;
        }

        @Override
        public ChooseFieldsInEquals checkingAllPossibilities() {
            this.classToValidateToAdd.validateEqualsAndHashCode();
            return this;
        }
    }

    public static interface AddClassToValidate {
        public ValidateEqualsAndHashCode classToValidate(Class<?> var1);

        public void validate();
    }

    public static interface ChooseFieldsInEquals {
        public AddClassToValidate ignoringFields(String ... var1);

        public AddClassToValidate withFieldNames(String ... var1);

        public AddClassToValidate withAllFields();
    }

    public static interface ValidateEqualsAndHashCode {
        public ChooseFieldsInEquals checkingAllPossibilities();

        public AddClassToValidate withoutCheckingAllPossibilities();
    }
}

