/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objenesis.ObjenesisHelper;
import org.unitils.core.UnitilsException;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.CompositeGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.objectvalidation.utils.TreeNodeCreator;
import org.unitils.util.ReflectionUtils;

class ObjectCreatorImpl
implements ObjectCreator {
    private static final Logger LOGGER = Logger.getLogger("ObjectCreator");
    private Generator generator;

    public ObjectCreatorImpl() {
        this.generator = new CompositeGenerator();
    }

    ObjectCreatorImpl(Generator ... generators) {
        CompositeGenerator gen = new CompositeGenerator();
        gen.addGenerators(generators);
        this.generator = gen;
    }

    @Override
    public Object createRandomObject(Type type) {
        TreeNode parentNode = TreeNodeCreator.createTreeNodeFor(type);
        Object randomObject = this.createFromTree(parentNode);
        if (!this.isPrimitive(randomObject)) {
            this.replaceFieldsWithRandom(randomObject);
        }
        return randomObject;
    }

    private boolean isPrimitive(Object object) {
        if (object == null) {
            return true;
        }
        Class<Collection> clazz = object.getClass();
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Integer.class || clazz == BigInteger.class || clazz == Float.class || clazz == Double.class || clazz == BigDecimal.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class || clazz == String.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == Calendar.class || clazz.isAssignableFrom(Collection.class) || Arrays.asList(clazz.getInterfaces()).contains(List.class) || Exception.class.isAssignableFrom(clazz);
    }

    private void replaceFieldsWithRandom(Object randomObject) {
        if (randomObject != null) {
            Set fields = ReflectionUtils.getAllFields(randomObject.getClass());
            for (Field field : fields) {
                try {
                    Object fieldValue;
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    if (field.getType().isPrimitive()) {
                        fieldValue = this.generator.generateObject(field.getType(), null, null, null);
                        ReflectionUtils.setFieldValue((Object)randomObject, (Field)field, (Object)fieldValue);
                        continue;
                    }
                    if (ReflectionUtils.getFieldValue((Object)randomObject, (Field)field) != null) continue;
                    fieldValue = null;
                    fieldValue = field.getType().equals(randomObject.getClass()) ? ObjenesisHelper.newInstance(field.getType()) : this.createRandomObject(field.getGenericType());
                    ReflectionUtils.setFieldValue((Object)randomObject, (Field)field, (Object)fieldValue);
                }
                catch (IllegalArgumentException e) {
                    throw new UnitilsException("Field " + field.getName() + " value could not be retrieved.", (Throwable)e);
                }
                catch (Exception e) {
                    throw new UnitilsException("Field " + field.getName() + " value could not be generated.", (Throwable)e);
                }
            }
        }
    }

    protected Object createFromTree(TreeNode parentNode) {
        ArrayList<Object> input = new ArrayList<Object>(parentNode.getChilds().size());
        ArrayList inputClasses = new ArrayList(parentNode.getChilds().size());
        for (TreeNode child : parentNode.getChilds()) {
            input.add(this.createFromTree(child));
            inputClasses.add(child.getValue());
        }
        try {
            return this.generator.generateObject(parentNode.getValue(), input, inputClasses, parentNode.getGenericSubtype());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Invocation on the generator has made a mistake. Try adding a custom generator for the object '" + parentNode.getValue().getName() + "' the factory has problems with.", e);
            return null;
        }
    }

    @Override
    public void addGenerators(Generator ... generators) {
        CompositeGenerator gen = (CompositeGenerator)this.generator;
        gen.addGenerators(generators);
    }
}

