/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.easymock.classextension.internal.objenesis.ObjenesisStd;
import org.unitils.core.UnitilsException;
import org.unitils.mock.core.MockObject;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.GenericsGenerator;
import org.unitils.objectvalidation.objectcreator.generator.PrimitiveGenerator;
import org.unitils.objectvalidation.utils.ObjectCreatorTypeWrapper;
import org.unitils.util.ReflectionUtils;

public class ObjectCreatorMockedFieldsImpl
implements ObjectCreator {
    private static final Log LOGGER = LogFactory.getLog(ObjectCreatorMockedFieldsImpl.class);
    private GenericsGenerator genericsGenerator;
    private PrimitiveGenerator primitiveGenerator;
    private static Map<Class<?>, MockObject<?>> mocks = new HashMap();
    private MockObject<Object> mockObj;

    public ObjectCreatorMockedFieldsImpl() {
        this.primitiveGenerator = new PrimitiveGenerator();
        this.genericsGenerator = new GenericsGenerator();
    }

    public ObjectCreatorMockedFieldsImpl(GenericsGenerator genericsGenerator, PrimitiveGenerator primitiveGenerator) {
        this.genericsGenerator = genericsGenerator;
        this.primitiveGenerator = primitiveGenerator;
    }

    @Override
    public Object createRandomObject(Type type) {
        Object randomObject = null;
        ObjectCreatorTypeWrapper typeWrapper = new ObjectCreatorTypeWrapper(type);
        Object obj = this.createRealObject(typeWrapper);
        if (obj != null) {
            return obj;
        }
        if (typeWrapper.isClassType() || typeWrapper.isInterface()) {
            Class<?> clzz = typeWrapper.getClassOfType();
            randomObject = this.createInstance(typeWrapper);
            for (Field field : ReflectionUtils.getAllFields(clzz)) {
                if (this.isConstant(field)) continue;
                field.setAccessible(true);
                Class<?> clazzField = null;
                try {
                    clazzField = Class.forName(((Class)field.getGenericType()).getName());
                }
                catch (Exception e) {
                    clazzField = field.getType();
                }
                ReflectionUtils.setFieldValue((Object)randomObject, (Field)field, (Object)this.createRealOrMockObject(new ObjectCreatorTypeWrapper(clazzField)));
            }
        } else {
            throw new UnitilsException("Can only manage classes and interfaces. Abstract classes, generics, wildcard types are not handled by the mocked creator.");
        }
        return randomObject;
    }

    protected Map<Object, Object> createMap(ParameterizedType type) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Type[] typeArguments = type.getActualTypeArguments();
        Set<Class<?>> clzzesKey = this.genericsGenerator.getClassesFromTypeArguments(typeArguments[0]);
        Set<Class<?>> clzzesValue = this.genericsGenerator.getClassesFromTypeArguments(typeArguments[1]);
        for (int i = 0; i < new Random().nextInt(); ++i) {
            Object objKey = this.pickClassFromSetAndGenerateAnObject(clzzesKey);
            Object objValue = this.pickClassFromSetAndGenerateAnObject(clzzesValue);
            map.put(objKey, objValue);
        }
        return map;
    }

    protected Set<Object> createSet(ParameterizedType type) {
        Set<Class<?>> clzzes = this.genericsGenerator.getClassesFromAParameterizedType(type);
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < new Random().nextInt(); ++i) {
            set.add(this.pickClassFromSetAndGenerateAnObject(clzzes));
        }
        return set;
    }

    protected Object pickClassFromSetAndGenerateAnObject(Set<Class<?>> clzzes) {
        if (clzzes.isEmpty()) {
            clzzes = this.genericsGenerator.getClassesFromTypeArguments((Type)((Object)Object.class));
        }
        Class<?> clzz = new ArrayList(clzzes).get(new Random().nextInt(clzzes.size()));
        return this.createRealOrMockObject(new ObjectCreatorTypeWrapper(clzz));
    }

    protected List<Object> createList(ParameterizedType type) {
        return new ArrayList<Object>(this.createSet(type));
    }

    protected <T> T[] createStuffedArray(Class<T> clzz) {
        int randomNumber = new Random().nextInt(10);
        Set<Class<?>> clzzes = this.genericsGenerator.getClassesFromTypeArguments(clzz);
        Object[] arr = (Object[])Array.newInstance(clzz, randomNumber);
        for (int i = 0; i < randomNumber; ++i) {
            arr[i] = this.pickClassFromSetAndGenerateAnObject(clzzes);
        }
        return arr;
    }

    Object createInstance(ObjectCreatorTypeWrapper typeWrapper) {
        Object temp = this.createRealObject(typeWrapper);
        if (temp != null) {
            return temp;
        }
        Constructor<?> constructor = this.getConstructor(typeWrapper.getClassOfType());
        if (this.constructorNotEmpty(constructor)) {
            constructor.setAccessible(true);
            int i = 0;
            Class[] classes = (Class[])Array.newInstance(Class.class, constructor.getGenericParameterTypes().length);
            Object[] values = (Object[])Array.newInstance(Object.class, constructor.getGenericParameterTypes().length);
            for (Type parameterType : constructor.getGenericParameterTypes()) {
                ObjectCreatorTypeWrapper type = new ObjectCreatorTypeWrapper(parameterType);
                classes[i] = type.getClassOfType();
                values[i] = this.createRealOrMockObject(type);
                ++i;
            }
            return ReflectionUtils.createInstanceOfType(typeWrapper.getClassOfType(), (boolean)true, (Class[])classes, (Object[])values);
        }
        if (this.isDefaultConstructor(constructor)) {
            return ReflectionUtils.createInstanceOfType(typeWrapper.getClassOfType(), (boolean)true);
        }
        return null;
    }

    protected Object createRealObject(ObjectCreatorTypeWrapper typeWrapper) {
        Class<?> clzz = typeWrapper.getClassOfType();
        if (this.isPrimitive(typeWrapper)) {
            try {
                return this.primitiveGenerator.generateObject(clzz, null, null, null);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (Modifier.isFinal(clzz.getModifiers())) {
            return new ObjenesisStd().getInstantiatorOf(clzz).newInstance();
        }
        if (typeWrapper.isParameterizedType()) {
            ParameterizedType paramType = (ParameterizedType)typeWrapper.getWrappedType();
            ObjectCreatorTypeWrapper rawTypeWrapper = new ObjectCreatorTypeWrapper(paramType.getRawType());
            if (rawTypeWrapper.isMap()) {
                return this.createMap(paramType);
            }
            if (rawTypeWrapper.isSet()) {
                return this.createSet(paramType);
            }
            if (rawTypeWrapper.isList()) {
                return this.createList(paramType);
            }
        } else if (typeWrapper.isArray()) {
            return this.createStuffedArray(typeWrapper.getClassOfType());
        }
        return null;
    }

    protected Object createRealOrMockObject(ObjectCreatorTypeWrapper typeWrapper) {
        Object realObject = this.createRealObject(typeWrapper);
        if (realObject != null) {
            return realObject;
        }
        Class<?> clzz = typeWrapper.getClassOfType();
        if (mocks.containsKey(clzz)) {
            MockObject<?> mock = mocks.get(clzz);
            mock.resetBehavior();
            return mock.getObjectToInject();
        }
        this.mockObj = new MockObject(clzz, (Object)this);
        this.mockObj.resetBehavior();
        Object obj = null;
        this.mockObj.returns((Object)true).equals(obj);
        Object mock = this.mockObj.getObjectToInject();
        mocks.put(clzz, this.mockObj);
        return mock;
    }

    protected boolean constructorNotEmpty(Constructor<?> constructor) {
        return constructor != null && constructor.getParameterTypes().length > 0;
    }

    protected boolean isDefaultConstructor(Constructor<?> constructor) {
        return constructor != null && constructor.getParameterTypes().length == 0;
    }

    protected Constructor<?> getConstructor(Class<?> clzz) {
        for (Constructor<?> constructor : clzz.getConstructors()) {
            if (constructor.isSynthetic()) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public void addGenerators(Generator ... generator) {
    }

    protected boolean isPrimitive(ObjectCreatorTypeWrapper wrapper) {
        return wrapper.isPrimitive() || wrapper.isString();
    }

    protected boolean isConstant(Field field) {
        return Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers());
    }
}

