/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.GenericsGenerator;
import org.unitils.objectvalidation.utils.TreeNode;

public class CollectionGenerator
implements Generator {
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 10;
    private final ObjectCreator objectCreator = ObjectCreatorFactory.createMocksObjectCreator();
    private final GenericsGenerator genericsGenerator = new GenericsGenerator();

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(Map.class)) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                for (int i = 0; i < CollectionGenerator.numberOfObjectsToGenerate(); ++i) {
                    Object key = this.createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(0).getValue());
                    Object value = this.createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(1).getValue());
                    hashMap.put(key, value);
                }
                return hashMap;
            }
            if (clazz.isAssignableFrom(List.class)) {
                return this.createListOf(genericSubTypes.isEmpty() ? new TreeNode(Object.class) : genericSubTypes.get(0));
            }
            if (clazz.isAssignableFrom(Set.class)) {
                if (CollectionUtils.isEmpty(genericSubTypes)) {
                    return new HashSet(this.createListOf(new TreeNode(Object.class)));
                }
                return new HashSet(this.createListOf(genericSubTypes.get(0)));
            }
        }
        if (clazz.isArray()) {
            TreeNode node = genericSubTypes.isEmpty() ? new TreeNode(Object.class) : genericSubTypes.get(0);
            List listOfObjects = this.createListOf(node);
            Object newInstance = Array.newInstance(node.getValue(), listOfObjects.size());
            for (int i = 0; i < listOfObjects.size(); ++i) {
                Array.set(newInstance, i, listOfObjects.get(i));
            }
            return newInstance;
        }
        return null;
    }

    private List createListOf(TreeNode genericSubTypes) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < CollectionGenerator.numberOfObjectsToGenerate(); ++i) {
            Object obj = this.genericsGenerator.generateObject(genericSubTypes.getValue(), null, null, Arrays.asList(genericSubTypes));
            if (obj == null) {
                obj = this.objectCreator.createRandomObject(genericSubTypes.getValue());
            }
            list.add(obj);
        }
        return list;
    }

    private <T> T createRandomObject(Class<T> clazz) {
        if (clazz == null) {
            return (T)this.objectCreator.createRandomObject((Type)((Object)Object.class));
        }
        return (T)this.objectCreator.createRandomObject(clazz);
    }

    private static int numberOfObjectsToGenerate() {
        return 1 + (int)(Math.random() * 10.0);
    }
}

