/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.easymock.classextension.internal.objenesis.ObjenesisStd;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.SubTypesScanner;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.helper.ClassPathHelperExtended;
import org.unitils.objectvalidation.utils.TreeNode;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;

public class GenericsGenerator
implements Generator {
    private static final Log LOGGER = LogFactory.getLog(GenericsGenerator.class);
    private final Reflections reflections = new Reflections(new Object[]{new SubTypesScanner(false), ClassPathHelperExtended.forProject(this.getClass().getClassLoader())});
    private ObjenesisStd objenesisStd = new ObjenesisStd();

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) {
        if (clazz.isAssignableFrom(ParameterizedType.class) || clazz.isAssignableFrom(WildcardTypeImpl.class)) {
            HashSet tempClasses = new HashSet();
            for (TreeNode treeNode : genericSubTypes) {
                tempClasses.addAll(this.getClassesFromAParameterizedType(treeNode.getParameterizedType()));
            }
            return this.pickAndCreateAnObjectFromASet(tempClasses);
        }
        return null;
    }

    public Set<Class<?>> getClassesFromAParameterizedType(ParameterizedType type) {
        HashSet classesParamType = new HashSet();
        if (type != null) {
            Type[] typeArg;
            for (Type type2 : typeArg = type.getActualTypeArguments()) {
                classesParamType.addAll(this.getClassesFromTypeArguments(type2));
            }
        }
        return classesParamType;
    }

    public Set<Class<?>> getClassesFromTypeArguments(Type type) {
        Set<Class<?>> classesParamType = new HashSet();
        if (type instanceof WildcardTypeImpl) {
            WildcardTypeImpl wildCard = (WildcardTypeImpl)type;
            classesParamType = this.getClassesOfSubtypes(wildCard, classesParamType);
            classesParamType = this.getClassesOfSuperType(wildCard, classesParamType);
        } else {
            classesParamType.add((Class)type);
        }
        return classesParamType;
    }

    protected Object pickAndCreateAnObjectFromASet(Set<Class<?>> collClasses) {
        try {
            if (!(CollectionUtils.isEmpty(collClasses) || collClasses.size() == 1 && collClasses.contains(Object.class))) {
                return this.createRandomObjects(collClasses);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Something went wrong with creating one of the genrerics", (Throwable)e);
        }
        Set<Class<?>> asList = this.reflections.getSubTypesOf(Object.class);
        asList = this.getSetWithClassesThatOverridesASpecificMethod((Set<Class<? extends Object>>)asList, "equals", Object.class);
        asList = this.getSetWithClassesThatOverridesASpecificMethod(asList, "hashCode", new Class[0]);
        return this.createRandomObjects(asList);
    }

    public Object generateSubTypesObject(Class<?> classForType) {
        Set<Object> allClasses = new HashSet();
        if ((allClasses = this.getClassesOfSubtypes(classForType, allClasses)).isEmpty() && !classForType.isInterface() && !Modifier.isAbstract(classForType.getModifiers())) {
            allClasses.add(classForType);
        }
        return this.pickAndCreateAnObjectFromASet(allClasses);
    }

    protected Set<Class<? extends Object>> getSetWithClassesThatOverridesASpecificMethod(Set<Class<? extends Object>> set, String methodName, Class<?> ... parameterTypes) {
        HashSet<Class<? extends Object>> temp = new HashSet<Class<? extends Object>>(set);
        for (Class<? extends Object> clzz : set) {
            try {
                Method method = clzz.getMethod(methodName, parameterTypes);
                if (method.getDeclaringClass().equals(clzz)) continue;
                temp.remove(clzz);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {}
        }
        return temp;
    }

    protected Set<?> getClassesOfSubtypes(WildcardTypeImpl wildcard, Set<?> allClasses) {
        for (Type type : wildcard.getUpperBounds()) {
            allClasses = this.getClassesOfSubtypes((Class)type, allClasses);
        }
        return allClasses;
    }

    protected Set<?> getClassesOfSubtypes(Class<?> clzz, Set<?> allClasses) {
        try {
            Set<Class<?>> tempSubtypes = this.reflections.getSubTypesOf(clzz);
            allClasses = CollectionUtils.isEmpty(allClasses) ? tempSubtypes : this.compareSubtypesSets(allClasses, tempSubtypes);
        }
        catch (ReflectionsException reflectionsException) {
            // empty catch block
        }
        return allClasses;
    }

    protected Set<Class<?>> getClassesOfSuperType(WildcardTypeImpl wildcard, Set<Class<?>> allClasses) {
        for (Type type : wildcard.getLowerBounds()) {
            allClasses = this.getClassesOfSuperType((Class)type, allClasses);
        }
        return allClasses;
    }

    protected Set<Class<?>> getClassesOfSuperType(Class<?> clzz, Set<Class<?>> allClasses) {
        Set<Class<?>> tempSuperTypes = ReflectionUtils.getAllSuperTypes(clzz, (Predicate[])null);
        allClasses = CollectionUtils.isEmpty(allClasses) ? tempSuperTypes : this.compareSubtypesSets(allClasses, tempSuperTypes);
        return allClasses;
    }

    protected Object createRandomObjects(Set<Class<?>> classes) {
        ArrayList tempClasses = new ArrayList();
        for (Class<?> clzz : classes) {
            if (clzz.isInterface()) continue;
            tempClasses.add(clzz);
        }
        if (tempClasses.isEmpty()) {
            tempClasses.addAll(classes);
        }
        Random random = new Random();
        Class obj = (Class)tempClasses.get(random.nextInt(tempClasses.size()));
        return this.objenesisStd.getInstantiatorOf(obj).newInstance();
    }

    public Set<Class<?>> compareSubtypesSets(Set<?> set1, Set<?> set2) {
        return new HashSet(CollectionUtils.intersection(set1, set2));
    }
}

