/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.unitils.core.UnitilsException;

public class TypeWrapper {
    protected Type wrappedType;

    public TypeWrapper(Type wrappedType) {
        this.wrappedType = wrappedType;
    }

    public Type getWrappedType() {
        return this.wrappedType;
    }

    public String getName() {
        if (this.isClassType()) {
            return ((Class)this.wrappedType).getName();
        }
        return this.wrappedType.toString();
    }

    public boolean isPrimitive() {
        if (!this.isClassType()) {
            return false;
        }
        return ((Class)this.wrappedType).isPrimitive();
    }

    public boolean isClassType() {
        return this.wrappedType instanceof Class;
    }

    public boolean isParameterizedType() {
        return this.wrappedType instanceof ParameterizedType;
    }

    public boolean hasRawType(Type rawType) {
        if (this.wrappedType instanceof ParameterizedType) {
            Type rawWrappedType = ((ParameterizedType)this.wrappedType).getRawType();
            return rawWrappedType.equals(rawType);
        }
        return this.wrappedType.equals(rawType);
    }

    public boolean isOfType(Type type) {
        return this.wrappedType.equals(type);
    }

    public boolean isAssignableTo(Type type) {
        return this.isAssignable(type, this.wrappedType);
    }

    public boolean isAssignableFrom(Type type) {
        return this.isAssignable(this.wrappedType, type);
    }

    public Class<?> getSingleGenericClass() {
        Type genericType = this.getSingleGenericType();
        if (genericType instanceof ParameterizedType) {
            genericType = ((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        throw new UnitilsException("Unable to determine unique generic class for type: " + this.getName() + ".\n" + "Generic type is not a class: " + genericType);
    }

    public Type getSingleGenericType() {
        if (!(this.wrappedType instanceof ParameterizedType)) {
            throw new UnitilsException("Unable to determine unique generic type for type: " + this.getName() + ".\n" + "Type is not a generic type.");
        }
        Object[] genericTypes = ((ParameterizedType)this.wrappedType).getActualTypeArguments();
        if (genericTypes.length == 0) {
            throw new UnitilsException("Unable to determine unique generic type for type: " + this.getName() + ".\n" + "Type is not a generic type.");
        }
        if (genericTypes.length > 1) {
            throw new UnitilsException("Unable to determine unique generic type for type: " + this.getName() + ".\n" + "The type declares more than one generic type: " + Arrays.toString(genericTypes));
        }
        return genericTypes[0];
    }

    protected boolean isAssignable(Type toType, Type fromType) {
        if (fromType == null || toType == null) {
            return false;
        }
        if (toType.equals(fromType)) {
            return true;
        }
        if (Object.class.equals((Object)toType)) {
            return true;
        }
        if (fromType instanceof Class && toType instanceof Class) {
            return this.isAssignableClass((Class)toType, (Class)fromType);
        }
        if (fromType instanceof ParameterizedType && toType instanceof ParameterizedType) {
            return this.isAssignableParameterizedType((ParameterizedType)toType, (ParameterizedType)fromType);
        }
        if (toType instanceof WildcardType) {
            return this.isAssignableWildcardType((WildcardType)toType, fromType);
        }
        return false;
    }

    protected boolean isAssignableClass(Class<?> toClass, Class<?> fromClass) {
        if (Boolean.TYPE.equals(fromClass) && Boolean.class.isAssignableFrom(toClass) || Boolean.TYPE.equals(toClass) && Boolean.class.isAssignableFrom(fromClass)) {
            return true;
        }
        if (Character.TYPE.equals(fromClass) && Character.class.isAssignableFrom(toClass) || Character.TYPE.equals(toClass) && Character.class.isAssignableFrom(fromClass)) {
            return true;
        }
        if (Integer.TYPE.equals(fromClass) && Integer.class.isAssignableFrom(toClass) || Integer.TYPE.equals(toClass) && Integer.class.isAssignableFrom(fromClass)) {
            return true;
        }
        if (Long.TYPE.equals(fromClass) && Long.class.isAssignableFrom(toClass) || Long.TYPE.equals(toClass) && Long.class.isAssignableFrom(fromClass)) {
            return true;
        }
        if (Float.TYPE.equals(fromClass) && Float.class.isAssignableFrom(toClass) || Float.TYPE.equals(toClass) && Float.class.isAssignableFrom(fromClass)) {
            return true;
        }
        if (Double.TYPE.equals(fromClass) && Double.class.isAssignableFrom(toClass) || Double.TYPE.equals(toClass) && Double.class.isAssignableFrom(fromClass)) {
            return true;
        }
        return toClass.isAssignableFrom(fromClass);
    }

    protected boolean isAssignableParameterizedType(ParameterizedType toType, ParameterizedType fromType) {
        Type[] fromTypeArguments;
        Type[] toTypeArguments = toType.getActualTypeArguments();
        if (toTypeArguments.length != (fromTypeArguments = fromType.getActualTypeArguments()).length) {
            return false;
        }
        int size = toTypeArguments.length;
        for (int i = 0; i < size; ++i) {
            Type toTypeArgument = toTypeArguments[i];
            Type fromTypeArgument = fromTypeArguments[i];
            if (toTypeArgument.equals(fromTypeArgument) || toTypeArgument instanceof WildcardType && this.isAssignableWildcardType((WildcardType)toTypeArgument, fromTypeArgument)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAssignableWildcardType(WildcardType toType, Type fromType) {
        int i;
        Type[] upperBounds = toType.getUpperBounds();
        Type[] lowerBounds = toType.getLowerBounds();
        int size = upperBounds.length;
        for (i = 0; i < size; ++i) {
            if (this.isAssignable(upperBounds[i], fromType)) continue;
            return false;
        }
        size = lowerBounds.length;
        for (i = 0; i < size; ++i) {
            if (this.isAssignable(fromType, lowerBounds[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null || this.getClass() != value.getClass()) {
            return false;
        }
        TypeWrapper that = (TypeWrapper)value;
        return !(this.wrappedType != null ? !this.wrappedType.equals(that.wrappedType) : that.wrappedType != null);
    }

    public int hashCode() {
        return this.wrappedType != null ? this.wrappedType.hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

